/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import net.sourceforge.plantuml.klimt.MutableImage;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.awt.XColor;

public class UImage
implements UShape {
    private final MutableImage image;
    private final String formula;
    private final String rawFileName;

    public UImage(MutableImage image) {
        this(image, null, null);
    }

    private UImage(MutableImage image, String rawFileName, String formula) {
        this.image = image;
        this.formula = formula;
        this.rawFileName = rawFileName;
    }

    public final UImage withRawFileName(String rawFileName) {
        return new UImage(this.image, rawFileName, this.formula);
    }

    public final UImage withFormula(String formula) {
        return new UImage(this.image, this.rawFileName, formula);
    }

    public final String getRawFileName() {
        return this.rawFileName;
    }

    public final String getFormula() {
        return this.formula;
    }

    public UImage scale(double scale) {
        return new UImage(this.image.withScale(scale), this.rawFileName, this.formula);
    }

    public final PortableImage getImage(double withScale) {
        return this.image.withScale(withScale).getImage();
    }

    public int getWidth() {
        return this.image.getImage().getWidth() - 1;
    }

    public int getHeight() {
        return this.image.getImage().getHeight() - 1;
    }

    public UImage muteColor(XColor newColor) {
        return new UImage(this.image.muteColor(newColor), this.rawFileName, this.formula);
    }

    public UImage muteTransparentColor(XColor newColor) {
        return new UImage(this.image.muteTransparentColor(newColor), this.rawFileName, this.formula);
    }

    public UImage monochrome() {
        return new UImage(this.image.monochrome(), this.rawFileName, this.formula);
    }

    public double getScale() {
        return this.image.getScale();
    }
}

