/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.packetdiag;

import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class PacketBlock {
    private static final UStroke openerStroke = new UStroke(5.0, 5.0, 1.0);
    private final int width;
    private int height;
    private final String label;
    private final ISkinParam skinParam;
    private boolean leftOpen = false;
    private boolean rightOpen = false;

    public PacketBlock(int width, int height, String label, ISkinParam skinParam) {
        this.width = width;
        this.height = height;
        this.label = label;
        this.skinParam = skinParam;
    }

    public PacketBlock(int width, int height, String label, ISkinParam skinParam, boolean leftOpen, boolean rightOpen) {
        this.width = width;
        this.height = height;
        this.label = label;
        this.skinParam = skinParam;
        this.leftOpen = leftOpen;
        this.rightOpen = rightOpen;
    }

    public void openLeft(boolean leftOpen) {
        this.leftOpen = leftOpen;
    }

    public void openRight(boolean rightOpen) {
        this.rightOpen = rightOpen;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getDrawWidth(double scale) {
        return (double)this.width * scale;
    }

    public double getDrawHeight(double scale) {
        return (double)this.height * scale;
    }

    public String getLabel() {
        return this.label;
    }

    Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.packetdiagDiagram, SName.rectangle).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    Fashion getFashion() {
        return this.getStyle().getSymbolContext(this.skinParam.getIHtmlColorSet());
    }

    private TextBlock getLabelTextBlock(String label) {
        return Display.getWithNewlines(this.skinParam.getPragma(), label).create8(this.getStyle().getFontConfiguration(this.skinParam.getIHtmlColorSet()), HorizontalAlignment.CENTER, this.skinParam, CreoleMode.SIMPLE_LINE, LineBreakStrategy.NONE);
    }

    private TextBlock getLabelTextBlockAbbr(StringBounder stringBounder, double bitWidth) {
        UFont font = this.getStyle().getUFont();
        String pad = "...";
        XDimension2D padDim = stringBounder.calculateDimension(font, "...");
        XDimension2D labelDim = stringBounder.calculateDimension(font, this.label);
        double reqWidth = this.getDrawWidth(bitWidth);
        if (labelDim.getWidth() < reqWidth) {
            return this.getLabelTextBlock(this.label);
        }
        Object abbr = this.label;
        for (int i = this.label.length(); i > 0 && !(labelDim.getWidth() + padDim.getWidth() < reqWidth); --i) {
            abbr = this.label.substring(0, i) + "...";
            labelDim = stringBounder.calculateDimension(font, (String)abbr);
        }
        return this.getLabelTextBlock((String)abbr);
    }

    TextBlock getShapeTextBlock(StringBounder stringBounder, double bitWidth, double bitHeight) {
        double vMargin = 10.0;
        double reqWidth = this.getDrawWidth(bitWidth);
        final Fashion fashion = this.getFashion();
        final TextBlock label = this.getLabelTextBlockAbbr(stringBounder, bitWidth);
        double heightPreOffset = Math.max(0.0, this.getDrawHeight(bitHeight) - label.calculateDimension(stringBounder).getHeight() - 10.0 - 10.0);
        final TextBlock stereo = TextBlockUtils.empty(reqWidth, heightPreOffset);
        return new AbstractTextBlock(){

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereo.calculateDimension(stringBounder);
                XDimension2D dim = dimStereo.mergeTB(dimLabel);
                return new XDimension2D(dim.getWidth(), dim.getHeight() + 10.0 + 10.0);
            }

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = fashion.apply(ug);
                URectangle rect = URectangle.build(dim.getWidth(), dim.getHeight());
                URectangle shape = rect.rounded(fashion.getRoundCorner());
                shape.setDeltaShadow(fashion.getDeltaShadow());
                ug.draw(shape);
                TextBlock tb = TextBlockUtils.mergeTB(stereo, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(0.0, 10.0)));
            }
        };
    }
}

