/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.packetdiag;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.packetdiag.PacketBlock;
import net.sourceforge.plantuml.packetdiag.PacketIndicator;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class PacketDiagram
extends UmlDiagram {
    public static final int DEFAULT_COL_WIDTH = 16;
    private int colWidth = 16;
    private double bitWidth = 24.0;
    private double bitHeight = 32.0;
    private int scaleInterval = this.colWidth / 2;
    private boolean useDefaultScaleInterval = true;
    private ScaleDirection scaleDirection = ScaleDirection.LTR;
    private final List<PacketItem> packetItems = new ArrayList<PacketItem>();
    private List<List<PacketBlock>> packetGrid = new ArrayList<List<PacketBlock>>();
    private List<PacketIndicator> packetIndicators = new ArrayList<PacketIndicator>();
    private Style style;

    public PacketDiagram(UmlSource source, PreprocessingArtifact preprocessing) {
        super(source, UmlDiagramType.PACKET, null, preprocessing);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextMainBlock(fileFormatOption)).write(os);
    }

    @Override
    protected TextBlock getTextMainBlock(FileFormatOption fileFormatOption) {
        return new AbstractTextBlock(){

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return null;
            }

            @Override
            public void drawU(UGraphic ug) {
                double maxWidth = 0.0;
                double maxHeight = 0.0;
                for (PacketIndicator packetIndicator : PacketDiagram.this.packetIndicators) {
                    packetIndicator.drawU(ug);
                    ug = ug.apply(new UTranslate(PacketDiagram.this.bitWidth, 0.0));
                    XDimension2D iDim = packetIndicator.calculateDimension(ug.getStringBounder());
                    maxWidth += PacketDiagram.this.bitWidth;
                    maxHeight = Math.max(iDim.getHeight(), maxHeight);
                }
                ug = ug.apply(new UTranslate(-maxWidth, maxHeight));
                for (List list : PacketDiagram.this.packetGrid) {
                    double totalWidth = 0.0;
                    double drawHeight = 0.0;
                    for (PacketBlock block : list) {
                        TextBlock tb = block.getShapeTextBlock(ug.getStringBounder(), PacketDiagram.this.bitWidth, PacketDiagram.this.bitHeight);
                        XDimension2D dim = tb.calculateDimension(ug.getStringBounder());
                        totalWidth += dim.getWidth();
                        drawHeight = dim.getHeight();
                        tb.drawU(ug);
                        ug = ug.apply(new UTranslate(dim.getWidth(), 0.0));
                    }
                    ug = ug.apply(new UTranslate(-totalWidth, drawHeight));
                }
            }
        };
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("Packet Diagram");
    }

    @Override
    public String checkFinalError() {
        this.build();
        return super.checkFinalError();
    }

    boolean isUseDefaultScaleInterval() {
        return this.useDefaultScaleInterval;
    }

    public int getColWidth() {
        return this.colWidth;
    }

    public void setColWidth(int colWidth) {
        if (colWidth > 0) {
            this.colWidth = colWidth;
        }
    }

    int getFullIndicatorInterval() {
        return this.colWidth >= 4 ? this.colWidth / 4 : this.colWidth;
    }

    void updateScaleInterval(int value) {
        if (value > 0) {
            this.scaleInterval = Math.min(value, this.colWidth);
            this.useDefaultScaleInterval = false;
        }
    }

    void updateNodeHeight(int nodeHeight) {
        this.bitHeight = Math.max(nodeHeight, 0);
    }

    void setScaleDirection(ScaleDirection scaleDirection) {
        this.scaleDirection = scaleDirection;
    }

    void addPacketItem(PacketItem packetItem) {
        this.packetItems.add(packetItem);
    }

    public Style getStyle() {
        if (this.style == null) {
            this.style = StyleSignatureBasic.of(SName.root, SName.element, SName.packetdiagDiagram).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        }
        return this.style;
    }

    Optional<Integer> getLastPacketEnd() {
        return this.packetItems.isEmpty() ? Optional.empty() : Optional.of(this.packetItems.get((int)(this.packetItems.size() - 1)).bitEnd);
    }

    private void build() {
        if (this.isUseDefaultScaleInterval()) {
            this.updateScaleInterval(this.getColWidth() / 2);
        }
        this.adjustLayout();
        this.adjustColWidth();
        this.adjustIndicators();
        this.adjustBitWidth();
    }

    void adjustColWidth() {
        if (!this.packetGrid.isEmpty()) {
            int maxWidth = this.packetGrid.get(0).stream().mapToInt(PacketBlock::getWidth).sum();
            this.colWidth = Math.min(maxWidth, this.colWidth);
        }
    }

    void adjustIndicators() {
        int fullLengthInterval = this.getFullIndicatorInterval();
        IntStream idxStream = IntStream.iterate(0, i -> i + 1).limit(this.colWidth + 1);
        if (this.scaleDirection == ScaleDirection.RTL) {
            idxStream = IntStream.iterate(this.colWidth, i -> i - 1).limit(this.colWidth + 1);
        }
        this.packetIndicators = idxStream.mapToObj(i -> {
            boolean full = i % fullLengthInterval == 0;
            boolean numbered = i % this.scaleInterval == 0;
            return new PacketIndicator(full, numbered, i, this.getStyle(), this.getSkinParam());
        }).collect(Collectors.toList());
    }

    void adjustLayout() {
        ArrayList<List<PacketBlock>> grid = new ArrayList<List<PacketBlock>>();
        List<PacketBlock> currRow = PacketDiagram.createPacketRow(new PacketBlock[0]);
        int remainRowWidth = this.colWidth;
        for (PacketItem packet : this.packetItems) {
            Optional<PacketItem> op = this.fitPacketInRow(packet, remainRowWidth, currRow);
            if (op.isPresent()) {
                remainRowWidth = this.colWidth;
                grid.add(currRow);
                currRow = PacketDiagram.createPacketRow(new PacketBlock[0]);
                PacketItem p = op.get();
                int rowCnt = p.width / remainRowWidth;
                int remain = p.width % remainRowWidth;
                for (int i = 0; i < rowCnt; ++i) {
                    PacketBlock pb = p.toPacketBlock(remainRowWidth, true, true, this.getSkinParam());
                    grid.add(PacketDiagram.createPacketRow(pb));
                }
                if (remain > 0) {
                    PacketBlock pb = p.toPacketBlock(remainRowWidth, true, false, this.getSkinParam());
                    currRow.add(pb);
                    remainRowWidth -= remain;
                    continue;
                }
                ((PacketBlock)((List)grid.get(grid.size() - 1)).get(0)).openRight(false);
                continue;
            }
            if ((remainRowWidth -= packet.width) != 0) continue;
            remainRowWidth = this.colWidth;
            grid.add(currRow);
            currRow = PacketDiagram.createPacketRow(new PacketBlock[0]);
        }
        if (!currRow.isEmpty()) {
            grid.add(currRow);
        }
        grid.forEach(blocks -> {
            int maxH = blocks.stream().map(PacketBlock::getHeight).max(Integer::compare).orElse(1);
            blocks.forEach(blk -> blk.setHeight(maxH));
            if (this.scaleDirection == ScaleDirection.RTL) {
                Collections.reverse(blocks);
            }
        });
        this.packetGrid = grid;
    }

    void adjustBitWidth() {
        double bitScale = 3.0;
        this.bitWidth = this.getStyle().value(PName.FontSize).asDouble() * 3.0;
    }

    private static List<PacketBlock> createPacketRow(PacketBlock ... pbs) {
        ArrayList<PacketBlock> row = new ArrayList<PacketBlock>();
        Collections.addAll(row, pbs);
        return row;
    }

    private Optional<PacketItem> fitPacketInRow(PacketItem packet, int remainRowWidth, List<PacketBlock> row) {
        assert (remainRowWidth > 0);
        int overflow = packet.width - remainRowWidth;
        if (overflow > 0) {
            int margin = packet.width - remainRowWidth;
            int bitEnd = packet.bitEnd - margin;
            row.add(packet.toPacketBlock(remainRowWidth, false, true, this.getSkinParam()));
            return Optional.of(new PacketItem(margin, packet.height, bitEnd, packet.bitEnd, packet.desc));
        }
        row.add(packet.toPacketBlock(this.getSkinParam()));
        return Optional.empty();
    }

    static enum ScaleDirection {
        LTR,
        RTL;

    }

    static class PacketItem {
        final int width;
        final int height;
        final int bitStart;
        final int bitEnd;
        final String desc;
        int textRotation;

        private PacketItem(int width, int height, int bitStart, int bitEnd, String desc) {
            this.width = width;
            this.height = height;
            this.bitStart = bitStart;
            this.bitEnd = bitEnd;
            this.desc = desc == null ? "" : desc;
        }

        static PacketItem ofRange(int start, int end, int height, String desc) {
            int width = end - start + 1;
            return new PacketItem(width, height, start, end, desc);
        }

        PacketBlock toPacketBlock(ISkinParam skinParam) {
            return new PacketBlock(this.width, this.height, this.desc, skinParam);
        }

        PacketBlock toPacketBlock(int newWidth, boolean openLeft, boolean openRight, ISkinParam skinParam) {
            return new PacketBlock(Math.min(newWidth, this.width), this.height, this.desc, skinParam, openLeft, openRight);
        }
    }
}

