/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import net.sourceforge.plantuml.directdot.CounterOutputStream;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.utils.Log;

public class PngIOMetadata {
    private static final String copyleft = "Generated by https://plantuml.com";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWithMetadata(RenderedImage image, OutputStream os, String metadata, int dpi, String debugData, int level) throws IOException {
        int w = image.getWidth();
        int h = image.getHeight();
        String imageType = image.getClass().getSimpleName();
        String colorModel = image instanceof BufferedImage ? PngIOMetadata.getImageTypeName(((BufferedImage)image).getType()) : "unknown";
        Log.info(() -> "PngIOMetadata: starting, image " + w + "x" + h + " (" + imageType + ", " + colorModel + "), compression level=" + level + ", memory: " + PngIO.getUsedMemoryMB() + " MB");
        long startTotal = System.currentTimeMillis();
        long memBefore = PngIO.getUsedMemoryMB();
        ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
        try {
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            try {
                writeParam.setCompressionMode(2);
                writeParam.setCompressionQuality(PngIOMetadata.levelToQuality(level));
            }
            catch (Throwable t) {
                Log.debug(() -> "Warning: cannot set compression mode/quality");
            }
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
            IIOMetadata meta = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            if (dpi != 96) {
                PngIOMetadata.addDpi(meta, dpi);
            }
            if (debugData != null) {
                PngIOMetadata.addText(meta, "debug", debugData);
            }
            PngIOMetadata.addText(meta, "copyleft", copyleft);
            if (metadata != null) {
                PngIOMetadata.addiText(meta, "plantuml", metadata);
            }
            Log.debug(() -> "PngIOMetadata pngMetadata=" + String.valueOf(meta));
            IIOImage iioImage = new IIOImage(image, null, meta);
            Log.debug(() -> "PngIOMetadata iioImage=" + String.valueOf(iioImage));
            long startWrite = System.currentTimeMillis();
            CounterOutputStream cos = new CounterOutputStream(os);
            try (ImageOutputStream ios = SImageIO.createImageOutputStream(cos);){
                writer.setOutput(ios);
                writer.write(null, iioImage, writeParam);
                ios.flush();
                long writeDuration = System.currentTimeMillis() - startWrite;
                long totalDuration = System.currentTimeMillis() - startTotal;
                long memAfter = PngIO.getUsedMemoryMB();
                int byteCount = cos.getLength();
                Log.info(() -> "PngIOMetadata: PNG written, " + byteCount + " bytes (" + PngIOMetadata.formatSize(byteCount) + "), write: " + writeDuration + " ms, total: " + totalDuration + " ms, memory: " + memBefore + " -> " + memAfter + " MB (delta: " + (memAfter - memBefore) + " MB)");
            }
        }
        finally {
            writer.dispose();
        }
    }

    private static String formatSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        return String.format("%.2f MB", (double)bytes / 1048576.0);
    }

    private static String getImageTypeName(int type) {
        switch (type) {
            case 1: {
                return "INT_RGB";
            }
            case 2: {
                return "INT_ARGB";
            }
            case 3: {
                return "INT_ARGB_PRE";
            }
            case 4: {
                return "INT_BGR";
            }
            case 5: {
                return "3BYTE_BGR";
            }
            case 6: {
                return "4BYTE_ABGR";
            }
            case 7: {
                return "4BYTE_ABGR_PRE";
            }
            case 10: {
                return "BYTE_GRAY";
            }
            case 12: {
                return "BYTE_BINARY";
            }
            case 13: {
                return "BYTE_INDEXED";
            }
            case 11: {
                return "USHORT_GRAY";
            }
            case 8: {
                return "USHORT_565_RGB";
            }
            case 9: {
                return "USHORT_555_RGB";
            }
            case 0: {
                return "CUSTOM";
            }
        }
        return "type=" + type;
    }

    private static float levelToQuality(int level) {
        int L = Math.max(1, Math.min(9, level));
        return 1.0f - (float)(L - 1) / 8.0f;
    }

    private static void addDpi(IIOMetadata meta, double dpi) throws IIOInvalidTreeException {
        IIOMetadataNode dimension = new IIOMetadataNode("Dimension");
        IIOMetadataNode horizontalPixelSize = new IIOMetadataNode("HorizontalPixelSize");
        double value = dpi / 0.0254 / 1000.0;
        horizontalPixelSize.setAttribute("value", Double.toString(value));
        dimension.appendChild(horizontalPixelSize);
        IIOMetadataNode verticalPixelSize = new IIOMetadataNode("VerticalPixelSize");
        verticalPixelSize.setAttribute("value", Double.toString(value));
        dimension.appendChild(verticalPixelSize);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dimension);
        meta.mergeTree("javax_imageio_1.0", root);
    }

    private static void addiText(IIOMetadata meta, String key, String value) throws IIOInvalidTreeException {
        IIOMetadataNode text = new IIOMetadataNode("iTXt");
        IIOMetadataNode entry = new IIOMetadataNode("iTXtEntry");
        entry.setAttribute("keyword", key);
        entry.setAttribute("compressionFlag", "true");
        entry.setAttribute("compressionMethod", "0");
        entry.setAttribute("languageTag", "");
        entry.setAttribute("translatedKeyword", "");
        entry.setAttribute("text", value);
        text.appendChild(entry);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_png_1.0");
        root.appendChild(text);
        meta.mergeTree("javax_imageio_png_1.0", root);
    }

    private static void addText(IIOMetadata meta, String key, String value) throws IIOInvalidTreeException {
        IIOMetadataNode text = new IIOMetadataNode("tEXt");
        IIOMetadataNode entry = new IIOMetadataNode("tEXtEntry");
        entry.setAttribute("keyword", key);
        entry.setAttribute("value", value);
        text.appendChild(entry);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_png_1.0");
        root.appendChild(text);
        meta.mergeTree("javax_imageio_png_1.0", root);
    }
}

