/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.Log;
import net.sourceforge.plantuml.utils.StartUtils;

public class DiagramExtractor
implements ReadLine {
    private static final Pattern DIGITS = Pattern.compile("\\d+");
    private final ReadLine raw;
    private boolean finished = false;

    public DiagramExtractor(ReadLine raw, String suf) {
        int bloc = 0;
        String uid = null;
        if (suf != null && DIGITS.matcher(suf).matches()) {
            bloc = Integer.parseInt(suf);
        } else {
            uid = suf;
        }
        if (bloc < 0) {
            bloc = 0;
        }
        this.raw = raw;
        StringLocated s = null;
        try {
            while ((s = raw.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(s.getString()) || !this.checkUid(uid, s)) continue;
                if (bloc == 0) {
                    return;
                }
                --bloc;
            }
        }
        catch (IOException e) {
            Logme.error(e);
            Log.error("Error " + String.valueOf(e));
        }
        this.finished = true;
    }

    private boolean checkUid(String uid, StringLocated s) {
        if (uid == null) {
            return true;
        }
        return s.toString().matches(".*id=" + uid + "\\W.*");
    }

    @Override
    public StringLocated readLine() throws IOException {
        if (this.finished) {
            return null;
        }
        StringLocated result = this.raw.readLine();
        if (result != null && StartUtils.isArobaseEndDiagram(result.getString())) {
            this.finished = true;
            return null;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.raw.close();
    }
}

