/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.crash.CrashImage;
import net.sourceforge.plantuml.crash.ReportLog;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.project.GanttConstraint;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.GanttLayout;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.data.DisplayConfigData;
import net.sourceforge.plantuml.project.data.GanttModelData;
import net.sourceforge.plantuml.project.data.TaskDrawRegistryData;
import net.sourceforge.plantuml.project.data.TimeBoundsData;
import net.sourceforge.plantuml.project.data.TimelineStyleData;
import net.sourceforge.plantuml.project.draw.ResourceDraw;
import net.sourceforge.plantuml.project.draw.TaskDraw;
import net.sourceforge.plantuml.project.draw.header.TimeHeader;
import net.sourceforge.plantuml.project.time.TimePoint;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class GanttDiagramMainBlock
extends AbstractTextBlock {
    private final GanttDiagram diagram;
    private final TimeHeader timeHeader;
    private final GanttLayout layout;
    private final GanttModelData modelData;
    private final TimeBoundsData timeBounds;
    private final DisplayConfigData displayConfig;
    private final TimelineStyleData timelineStyle;
    private final TaskDrawRegistryData drawRegistry;

    public GanttDiagramMainBlock(TimeBoundsData timeBounds, GanttModelData modelData, TaskDrawRegistryData drawRegistry, DisplayConfigData displayConfig, TimelineStyleData timelineStyle, GanttDiagram diagram, TimeHeader timeHeader, StringBounder stringBounder) {
        this.diagram = diagram;
        this.timeBounds = timeBounds;
        this.modelData = modelData;
        this.drawRegistry = drawRegistry;
        this.displayConfig = displayConfig;
        this.timelineStyle = timelineStyle;
        this.timeHeader = timeHeader;
        this.layout = new GanttLayout(modelData, displayConfig, timeBounds, timelineStyle, drawRegistry, stringBounder, timeHeader);
    }

    @Override
    public void drawU(UGraphic ug) {
        try {
            Style style;
            HColor back;
            UGraphic ugOrig = ug;
            if (this.displayConfig.getLabelStrategy().titleInFirstColumn()) {
                ug = ug.apply(UTranslate.dx(this.layout.getTitlesWidth()));
            }
            if (!(back = (style = StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.timeline).getMergedStyle(this.timelineStyle.getSkinParam().getCurrentStyleBuilder())).value(PName.BackGroundColor).asColor(this.timelineStyle.getColorSet())).isTransparent()) {
                double fullWidth = this.layout.getTitlesWidth() + this.layout.getBarsWidth();
                URectangle rect1 = URectangle.build(fullWidth, this.layout.getHeaderHeight());
                ug.apply(back.bg()).draw(rect1);
                if (this.displayConfig.isShowFootbox()) {
                    URectangle rect2 = URectangle.build(fullWidth, this.layout.getFooterHeight());
                    ug.apply(back.bg()).apply(UTranslate.dy(this.drawRegistry.getTotalHeightWithoutFooter())).draw(rect2);
                }
            }
            this.timeHeader.drawTimeHeader(ug, this.drawRegistry.getTotalHeightWithoutFooter());
            this.drawConstraints(ug, this.timeHeader.getTimeScale());
            this.drawTasksRect(ug);
            this.drawTasksTitle(ugOrig, this.layout.getTitlesWidth(), this.layout.getBarsWidth());
            if (!this.displayConfig.isHideResourceFootbox()) {
                this.drawResources(ug);
            }
            if (this.displayConfig.isShowFootbox()) {
                this.timeHeader.drawTimeFooter(ug.apply(UTranslate.dy(this.drawRegistry.getTotalHeightWithoutFooter())));
            }
        }
        catch (Throwable e) {
            Logme.error(e);
            ReportLog report = new ReportLog();
            report.anErrorHasOccured(e, this.diagram.getFlashData());
            report.addProperties();
            report.addEmptyLine();
            report.youShouldSendThisDiagram();
            CrashImage image = new CrashImage(e, this.diagram.getFlashData(), report);
            image.drawU(ug);
        }
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.layout.calculateDimension();
    }

    private void drawTasksRect(UGraphic ug) {
        for (Task task : this.modelData.getTasks()) {
            if (this.timeBounds.isHidden(task)) continue;
            TaskDraw draw = this.drawRegistry.getTaskDraw(task);
            UTranslate move = UTranslate.dy(draw.getY(ug.getStringBounder()).getCurrentValue());
            draw.drawU(ug.apply(move));
        }
    }

    private void drawConstraints(UGraphic ug, TimeScale timeScale) {
        for (GanttConstraint constraint : this.modelData.getConstraints()) {
            if (this.timeBounds.getPrintStart() != null && constraint.isHidden(TimePoint.ofStartOfDay(this.timeBounds.getMinDay()), TimePoint.ofEndOfDayMinusOneSecond(this.timeBounds.getMaxDay()))) continue;
            constraint.getUDrawable(timeScale, this.drawRegistry).drawU(ug);
        }
    }

    private void drawTasksTitle(UGraphic ug, double colTitles, double colBars) {
        for (Task task : this.modelData.getTasks()) {
            if (this.timeBounds.isHidden(task)) continue;
            TaskDraw draw = this.drawRegistry.getTaskDraw(task);
            UTranslate move = UTranslate.dy(draw.getY(ug.getStringBounder()).getCurrentValue());
            draw.drawTitle(ug.apply(move), this.displayConfig.getLabelStrategy(), colTitles, colBars);
        }
    }

    private void drawResources(UGraphic ug) {
        for (Resource res : this.modelData.getResources()) {
            ResourceDraw draw = res.getResourceDraw();
            UTranslate move = UTranslate.dy(draw.getY());
            draw.drawU(ug.apply(move));
        }
    }
}

