/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.data.DisplayConfigData;
import net.sourceforge.plantuml.project.data.GanttModelData;
import net.sourceforge.plantuml.project.data.TaskDrawRegistryData;
import net.sourceforge.plantuml.project.data.TimeBoundsData;
import net.sourceforge.plantuml.project.data.TimelineStyleData;
import net.sourceforge.plantuml.project.draw.TaskDraw;
import net.sourceforge.plantuml.project.draw.header.TimeHeader;

public final class GanttLayout {
    private final double titlesWidth;
    private final double barsWidth;
    private double totalHeight;
    private double headerHeight;
    private double footerHeight;

    public GanttLayout(GanttModelData modelData, DisplayConfigData displayConfig, TimeBoundsData timeBounds, TimelineStyleData timelineStyle, TaskDrawRegistryData drawRegistry, StringBounder stringBounder, TimeHeader timeHeader) {
        double computedTitlesWidth;
        drawRegistry.buildTaskAndResourceDraws(stringBounder, timeHeader, modelData, displayConfig, timeBounds, timelineStyle);
        if (displayConfig.getLabelStrategy().titleInside()) {
            computedTitlesWidth = 0.0;
        } else {
            double w = 0.0;
            for (Task task : modelData.getTasks()) {
                TaskDraw draw;
                if (timeBounds.isHidden(task) || (draw = drawRegistry.getTaskDraw(task)) == null) continue;
                w = Math.max(w, draw.getTitleWidth(stringBounder));
            }
            computedTitlesWidth = w;
        }
        this.titlesWidth = computedTitlesWidth;
        this.barsWidth = timeBounds.getBarsColumnWidth(timeHeader);
        this.headerHeight = timeHeader.getTimeHeaderHeight(stringBounder);
        this.footerHeight = displayConfig.isShowFootbox() ? timeHeader.getTimeFooterHeight(stringBounder) : 0.0;
        this.totalHeight = drawRegistry.getTotalHeightWithoutFooter() + this.footerHeight;
    }

    public XDimension2D calculateDimension() {
        double width = this.titlesWidth + this.barsWidth;
        return new XDimension2D(width, this.totalHeight);
    }

    public double getTitlesWidth() {
        return this.titlesWidth;
    }

    public double getBarsWidth() {
        return this.barsWidth;
    }

    public double getTotalHeight() {
        return this.totalHeight;
    }

    public double getHeaderHeight() {
        return this.headerHeight;
    }

    public double getFooterHeight() {
        return this.footerHeight;
    }
}

