/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.stereo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Parser;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.regex.RegexComposed;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.text.Guillemet;

public class StereotypeDecoration {
    private static final RegexComposed circleChar = new RegexConcat(new RegexLeaf("\\<\\<"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\("), new RegexLeaf(1, "CHAR", "(\\S)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf(","), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "COLOR", "(#[0-9a-fA-F]{6}|\\w+)"), RegexLeaf.spaceZeroOrMore())), new RegexLeaf("\\)"), new RegexOptional((IRegex)new RegexLeaf(1, "LABEL", "[,]?(.*?)")), new RegexLeaf("\\>\\>"));
    private static final RegexComposed circleSprite = new RegexConcat(new RegexLeaf("\\<\\<"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\(?\\$"), new RegexLeaf(1, "NAME", "([-\\p{L}0-9_/]+)"), new RegexLeaf(2, "SCALE", "((?:\\{scale=|\\*)([0-9.]+)\\}?)?"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(","), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "COLOR", "(#[0-9a-fA-F]{6}|\\w+)"))), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "LABEL", "[),](.*?)")), new RegexLeaf("\\>\\>"));
    final String label;
    final HColor htmlColor;
    final char character;
    final String spriteName;
    final double spriteScale;
    private static final Pattern2 p = Pattern2.cmpile("\\<{2,3}.*?\\>{2,3}");

    public String toString() {
        return "label='" + this.label + "' spriteName='" + this.spriteName + "'";
    }

    public List<String> getStyleNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : StereotypeDecoration.cutLabels(this.label, Guillemet.NONE)) {
            result.add(s);
        }
        if (this.spriteName == null) {
            return Collections.unmodifiableList(result);
        }
        int idx = this.spriteName.lastIndexOf(47);
        if (idx != -1) {
            result.add(this.spriteName.substring(idx + 1));
        }
        return Collections.unmodifiableList(result);
    }

    private StereotypeDecoration(String label, HColor htmlColor, char character, String spriteName, double spriteScale) {
        this.label = label;
        this.htmlColor = htmlColor;
        this.character = character;
        this.spriteName = spriteName;
        this.spriteScale = spriteScale;
    }

    static StereotypeDecoration buildSimple(String name) {
        double spriteScale;
        String spriteName;
        if (name.startsWith("<<$") && name.endsWith(">>")) {
            RegexResult mCircleSprite = circleSprite.matcher(name);
            spriteName = mCircleSprite.get("NAME", 0);
            spriteScale = Parser.getScale(mCircleSprite.get("SCALE", 0), 1.0);
        } else {
            spriteName = null;
            spriteScale = 0.0;
        }
        return new StereotypeDecoration(name, null, '\u0000', spriteName, spriteScale);
    }

    /*
     * WARNING - void declaration
     */
    public static StereotypeDecoration buildComplex(String full, HColorSet htmlColorSet) throws NoSuchColorException {
        Object label = "";
        HColor htmlColor = null;
        char character = '\u0000';
        String spriteName = null;
        double spriteScale = 0.0;
        List<String> list = StereotypeDecoration.cutLabels(full, Guillemet.DOUBLE_COMPARATOR);
        for (String string : list) {
            void var10_9;
            String colName;
            RegexResult mCircleChar = circleChar.matcher(string);
            RegexResult mCircleSprite = circleSprite.matcher(string);
            if (mCircleSprite != null) {
                if (StringUtils.isNotEmpty(mCircleSprite.get("LABEL", 0))) {
                    String string2 = "<<" + mCircleSprite.get("LABEL", 0) + ">>";
                } else {
                    String string3 = "";
                }
                colName = mCircleSprite.get("COLOR", 0);
                HColor col = colName == null ? null : htmlColorSet.getColor(colName);
                htmlColor = col == null ? HColors.BLACK : col;
                character = '\u0000';
                spriteName = mCircleSprite.get("NAME", 0);
                spriteScale = Parser.getScale(mCircleSprite.get("SCALE", 0), 1.0);
            } else if (mCircleChar != null) {
                if (StringUtils.isNotEmpty(mCircleChar.get("LABEL", 0))) {
                    String string4 = "<<" + mCircleChar.get("LABEL", 0) + ">>";
                } else {
                    String string5 = "";
                }
                colName = mCircleChar.get("COLOR", 0);
                htmlColor = colName == null ? null : htmlColorSet.getColor(colName);
                character = mCircleChar.get("CHAR", 0).charAt(0);
            }
            label = (String)label + (String)var10_9;
        }
        return new StereotypeDecoration((String)label, htmlColor, character, spriteName, spriteScale);
    }

    static List<String> cutLabels(String label, Guillemet guillemet) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher2 m = p.matcher(label);
        while (m.find()) {
            String group = m.group();
            if (group.startsWith("<<<")) continue;
            result.add(guillemet.manageGuillemetStrict(group));
        }
        return Collections.unmodifiableList(result);
    }
}

