/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.atmp.CucaDiagram;
import net.atmp.ImageBuilder;
import net.sourceforge.plantuml.AnnotatedBuilder;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.crash.GraphvizCrash;
import net.sourceforge.plantuml.dot.DotData;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.svek.BaseFile;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.GraphvizImageBuilder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.teavm.browser.BrowserLog;

public final class CucaDiagramFileMakerTeaVM
extends CucaDiagramFileMaker {
    public CucaDiagramFileMakerTeaVM(CucaDiagram diagram) {
        super(diagram);
    }

    @Override
    public ImageData createFile(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        throw new UnsupportedOperationException("TEAVM100");
    }

    @Override
    public void createOneGraphic(UGraphic ug) {
        BrowserLog.consoleLog(CucaDiagramFileMakerTeaVM.class, "creating dot");
        String[] dot = this.diagram.getDotStringSkek();
        ArrayList<String> dots = new ArrayList<String>();
        for (String s : dot) {
            dots.add(s);
        }
        try {
            BrowserLog.consoleLog(CucaDiagramFileMakerTeaVM.class, "wip1");
            this.createFileInternal(ug, dots);
            BrowserLog.consoleLog(CucaDiagramFileMakerTeaVM.class, "wip2");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("TEAVM103");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("TEAVM105");
        }
        BrowserLog.consoleLog(CucaDiagramFileMakerTeaVM.class, "done");
    }

    private void createFileInternal(UGraphic ug, List<String> dotStrings) throws IOException, InterruptedException {
        StringBounder stringBounder = ug.getStringBounder();
        DotStringFactory dotStringFactory = new DotStringFactory(this.bibliotekon, this.clusterManager.getCurrent(), this.diagram.getUmlDiagramType(), this.diagram.getSkinParam());
        DotData dotData = new DotData(this.diagram, this.diagram.getRootGroup(), this.getOrderedLinks(), this.diagram.leafs(), this.diagram, this.diagram);
        GraphvizImageBuilder imageBuilder = new GraphvizImageBuilder(dotData, this.diagram.getSource(), this.diagram.getPragma(), this.diagram.getUmlDiagramType().getStyleName(), DotMode.NORMAL, dotStringFactory, this.clusterManager);
        BaseFile basefile = null;
        TextBlock result = imageBuilder.buildImage(stringBounder, basefile, this.diagram.getDotStringSkek(), false);
        int status = 0;
        if (result instanceof IEntityImage && result.isCrash()) {
            status = 503;
        }
        if (result instanceof GraphvizCrash) {
            status = 503;
            imageBuilder = new GraphvizImageBuilder(dotData, this.diagram.getSource(), this.diagram.getPragma(), this.diagram.getUmlDiagramType().getStyleName(), DotMode.NO_LEFT_RIGHT_AND_XLABEL, dotStringFactory, this.clusterManager);
            result = imageBuilder.buildImage(stringBounder, basefile, this.diagram.getDotStringSkek(), false);
        }
        AnnotatedBuilder builder = new AnnotatedBuilder(this.diagram, this.diagram.getSkinParam(), stringBounder);
        result = new AnnotatedWorker(this.diagram, builder).addAdd(result);
        String widthwarning = this.diagram.getSkinParam().getValue("widthwarning");
        String warningOrError = null;
        if (widthwarning != null && widthwarning.matches("\\d+")) {
            warningOrError = imageBuilder.getWarningOrError(Integer.parseInt(widthwarning));
        }
        result.calculateDimension(stringBounder);
        ImageBuilder ib = this.diagram.createImageBuilder(new FileFormatOption(FileFormat.SVG)).annotations(false).drawable(result).status(status).warningOrError(warningOrError);
        ib.udrawable.drawU(ug);
    }

    private List<Link> getOrderedLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link l : this.diagram.getLinks()) {
            this.addLinkNew(result, l);
        }
        return result;
    }

    private void addLinkNew(List<Link> result, Link link) {
        for (int i = 0; i < result.size(); ++i) {
            Link other = result.get(i);
            if (!other.sameConnections(link)) continue;
            while (i < result.size() && result.get(i).sameConnections(link)) {
                ++i;
            }
            if (i == result.size()) {
                result.add(link);
            } else {
                result.add(i, link);
            }
            return;
        }
        result.add(link);
    }
}

