/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class CircleStart
implements UDrawable {
    private static final int SIZE = 20;
    private final ISkinParam skinParam;
    private final Style style;
    private final Colors colors;

    public CircleStart(ISkinParam skinParam, Style style, Colors colors) {
        this.style = style;
        this.colors = colors;
        this.skinParam = skinParam;
    }

    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(20.0, 20.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UEllipse circle = UEllipse.build(20.0, 20.0);
        HColor backColor = this.colors.getColor(this.style, PName.BackGroundColor, this.skinParam.getIHtmlColorSet());
        HColor lineColor = this.colors.getColor(this.style, PName.LineColor, this.skinParam.getIHtmlColorSet());
        double shadowing = this.style.getShadowing();
        circle.setDeltaShadow(shadowing);
        ug.apply(lineColor).apply(backColor.bg()).apply(this.style.getStroke()).draw(circle);
    }
}

