/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.image.CircleEnd;

public class EntityImageCircleEnd
extends AbstractEntityImage {
    private static final int SIZE = 22;
    private final CircleEnd circle;

    public StyleSignatureBasic getDefaultStyleDefinitionCircle() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.getSkinParam().getUmlDiagramType().getStyleName(), SName.circle, SName.end);
    }

    public EntityImageCircleEnd(Entity entity) {
        super(entity);
        Style style = this.getDefaultStyleDefinitionCircle().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        this.circle = new CircleEnd(this.getSkinParam(), style, entity.getColors());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(22.0, 22.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UGroup group = new UGroup(this.getEntity().getLocation());
        group.put(UGroupType.CLASS, "end_entity");
        group.put(UGroupType.ID, "entity_" + this.getEntity().getName());
        group.put(UGroupType.DATA_ENTITY, this.getEntity().getName());
        group.put(UGroupType.DATA_UID, this.getEntity().getUid());
        group.put(UGroupType.DATA_QUALIFIED_NAME, this.getEntity().getQuark().getQualifiedName());
        ug.startGroup(group);
        this.circle.drawU(ug);
        ug.closeGroup();
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

