/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.klimt.awt.PortableImage;
import net.sourceforge.plantuml.klimt.awt.PortableImageFactory;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.swing.ImageSelection;
import net.sourceforge.plantuml.utils.Log;

public class ClipboardLoop {
    public static void runLoop() {
        ClipboardLoop clipboardLoop = new ClipboardLoop();
        try {
            while (true) {
                String text;
                if (clipboardLoop.isTextOk(text = clipboardLoop.getClipboardText())) {
                    clipboardLoop.runText(text);
                }
                Thread.sleep(10000L);
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public static void runOnce() {
        ClipboardLoop clipboardLoop = new ClipboardLoop();
        String text = clipboardLoop.getClipboardText();
        try {
            if (clipboardLoop.isTextOk(text)) {
                clipboardLoop.runText(text);
            } else {
                clipboardLoop.setClipboardImage(PortableImageFactory.build(10, 10, 2));
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    private boolean isTextOk(String text) {
        if (text == null) {
            return false;
        }
        return text.startsWith("@start");
    }

    private void runText(String text) throws IOException, InterruptedException {
        Log.info(() -> "Getting some text from clipboard");
        SourceStringReader source = new SourceStringReader(text);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DiagramDescription desc = source.outputImage(baos);
        if (desc == null) {
            Log.info(() -> "No image generated");
        } else {
            Log.info(() -> "Image ok " + desc.getDescription());
            baos.close();
            PortableImage image = SImageIO.read(baos.toByteArray());
            this.setClipboardImage(image);
            Log.info(() -> "Image copied in clipboard");
        }
    }

    private String getClipboardText() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                return text;
            }
        }
        catch (UnsupportedFlavorException e) {
            Log.error(e.toString());
        }
        catch (IOException e) {
            Log.error(e.toString());
        }
        return null;
    }

    private void setClipboardImage(PortableImage image) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new ImageSelection(image.getBufferedImage()), null);
    }
}

