/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.teavm;

import java.util.Locale;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.geom.USegment;
import net.sourceforge.plantuml.klimt.geom.USegmentType;
import net.sourceforge.plantuml.klimt.shape.DotPath;
import net.sourceforge.plantuml.teavm.DriverRectangleTeaVM;
import net.sourceforge.plantuml.teavm.SvgGraphicsTeaVM;

public class DriverDotPathTeaVM
implements UDriver<DotPath, SvgGraphicsTeaVM> {
    @Override
    public void draw(DotPath shape, double x, double y, ColorMapper mapper, UParam param, SvgGraphicsTeaVM svg) {
        if (param.getColor().isTransparent()) {
            return;
        }
        DriverRectangleTeaVM.applyStrokeColor(svg, mapper, param);
        svg.setFillColor("none");
        svg.setStrokeWidth(param.getStroke().getThickness());
        StringBuilder pathData = new StringBuilder();
        for (USegment seg : shape.toUPath()) {
            USegmentType type = seg.getSegmentType();
            double[] coord = seg.getCoord();
            if (type == USegmentType.SEG_MOVETO) {
                pathData.append("M").append(this.format(coord[0] + x)).append(",").append(this.format(coord[1] + y)).append(" ");
                continue;
            }
            if (type != USegmentType.SEG_CUBICTO) continue;
            pathData.append("C").append(this.format(coord[0] + x)).append(",").append(this.format(coord[1] + y)).append(" ").append(this.format(coord[2] + x)).append(",").append(this.format(coord[3] + y)).append(" ").append(this.format(coord[4] + x)).append(",").append(this.format(coord[5] + y)).append(" ");
        }
        svg.drawPath(pathData.toString().trim());
    }

    private String format(double x) {
        if (x == 0.0) {
            return "0";
        }
        String s = String.format(Locale.US, "%.4f", x);
        int dot = s.indexOf(46);
        if (dot >= 0) {
            int end;
            for (end = s.length() - 1; end > dot && s.charAt(end) == '0'; --end) {
            }
            if (end == dot) {
                --end;
            }
            s = s.substring(0, end + 1);
        }
        return s;
    }
}

