/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.teavm;

import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.teavm.SvgGraphicsTeaVM;

public class StringBounderTeaVM
implements StringBounder {
    @Override
    public XDimension2D calculateDimension(UFont font, String text) {
        if (text == null || text.isEmpty()) {
            return new XDimension2D(0.0, 0.0);
        }
        String fontFamily = font.getFamily(null, null);
        int fontSize = font.getSize();
        String fontWeight = font.isBold() ? "bold" : "normal";
        double[] metrics = SvgGraphicsTeaVM.measureTextCanvas(text, fontFamily, fontSize, fontWeight);
        double width = metrics[0];
        double[] svgMetrics = SvgGraphicsTeaVM.measureTextSvgBBox(text, fontFamily, fontSize);
        double height = svgMetrics[1];
        if (height == 0.0 && !text.isEmpty()) {
            double[] detailedMetrics = SvgGraphicsTeaVM.getDetailedTextMetrics(text, fontFamily, fontSize, fontWeight);
            height = detailedMetrics[3] + detailedMetrics[4];
        }
        return new XDimension2D(width, height);
    }

    @Override
    public double getDescent(UFont font, String text) {
        if (text == null || text.isEmpty()) {
            return 0.0;
        }
        String fontFamily = font.getFamily(null, null);
        int fontSize = font.getSize();
        String fontWeight = font.isBold() ? "bold" : "normal";
        double[] metrics = SvgGraphicsTeaVM.getDetailedTextMetrics(text, fontFamily, fontSize, fontWeight);
        return metrics[2];
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        if ("TEAVM".equalsIgnoreCase(propertyName)) {
            return true;
        }
        return "SVG".equalsIgnoreCase(propertyName);
    }
}

