/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.teavm;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.AbstractCommonUGraphic;
import net.sourceforge.plantuml.klimt.drawing.AbstractUGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.DotPath;
import net.sourceforge.plantuml.klimt.shape.UCenteredCharacter;
import net.sourceforge.plantuml.klimt.shape.UComment;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.shape.UImageSvg;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPixel;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.teavm.DriverCenteredCharacterTeaVM;
import net.sourceforge.plantuml.teavm.DriverDotPathTeaVM;
import net.sourceforge.plantuml.teavm.DriverEllipseTeaVM;
import net.sourceforge.plantuml.teavm.DriverImageSvgTeaVM;
import net.sourceforge.plantuml.teavm.DriverImageTeaVM;
import net.sourceforge.plantuml.teavm.DriverLineTeaVM;
import net.sourceforge.plantuml.teavm.DriverPathTeaVM;
import net.sourceforge.plantuml.teavm.DriverPolygonTeaVM;
import net.sourceforge.plantuml.teavm.DriverRectangleTeaVM;
import net.sourceforge.plantuml.teavm.DriverTextTeaVM;
import net.sourceforge.plantuml.teavm.SvgGraphicsTeaVM;
import net.sourceforge.plantuml.url.Url;

public class UGraphicTeaVM
extends AbstractUGraphic<SvgGraphicsTeaVM>
implements ClipContainer {
    private UGraphicTeaVM(StringBounder stringBounder) {
        super(stringBounder);
        this.register();
    }

    public static UGraphicTeaVM build(HColor defaultBackground, ColorMapper colorMapper, StringBounder stringBounder, SvgGraphicsTeaVM svg) {
        UGraphicTeaVM result = new UGraphicTeaVM(stringBounder);
        result.copy(defaultBackground, colorMapper, svg);
        return result;
    }

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        UGraphicTeaVM result = new UGraphicTeaVM(this.getStringBounder());
        result.copy(this);
        return result;
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverRectangleTeaVM(this));
        this.registerDriver(ULine.class, new DriverLineTeaVM(this));
        this.registerDriver(UPolygon.class, new DriverPolygonTeaVM(this));
        this.registerDriver(UEllipse.class, new DriverEllipseTeaVM(this));
        this.registerDriver(UText.class, new DriverTextTeaVM(this));
        this.registerDriver(UPath.class, new DriverPathTeaVM(this));
        this.registerDriver(UImage.class, new DriverImageTeaVM(this));
        this.registerDriver(UImageSvg.class, new DriverImageSvgTeaVM());
        this.registerDriver(DotPath.class, new DriverDotPathTeaVM());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterTeaVM());
        this.ignoreShape(UPixel.class);
    }

    public SvgGraphicsTeaVM getSvgGraphics() {
        return (SvgGraphicsTeaVM)this.getGraphicObject();
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        throw new UnsupportedOperationException("TEAVM442");
    }

    @Override
    public void startGroup(UGroup group) {
    }

    @Override
    public void closeGroup() {
    }

    @Override
    public void startUrl(Url url) {
    }

    @Override
    public void closeUrl() {
    }

    @Override
    protected void drawComment(UComment comment) {
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        if (propertyName.equalsIgnoreCase("TEAVM")) {
            return true;
        }
        if (propertyName.equalsIgnoreCase("SVG")) {
            return true;
        }
        return super.matchesProperty(propertyName);
    }
}

