/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.teavm.browser;

import net.sourceforge.plantuml.teavm.TeaVM;
import net.sourceforge.plantuml.version.Version;
import org.teavm.jso.JSBody;

public class BrowserLog {
    private static long START = System.currentTimeMillis();

    public static void reset() {
        START = System.currentTimeMillis();
        BrowserLog.consoleMessage("==============================");
    }

    public static void consoleLog(Class<?> clazz, String msg) {
        BrowserLog.consoleMessage("[" + clazz.getSimpleName() + "] " + msg);
    }

    private static void consoleMessage(String msg) {
        if (TeaVM.isTeaVM()) {
            String message = BrowserLog.getMessage(msg);
            BrowserLog.jsLog(message);
        }
    }

    private static String getMessage(String msg) {
        long durationMs = System.currentTimeMillis() - START;
        return String.format("[%6d ms] %s", durationMs, msg);
    }

    public static void jsStatusDuration() {
        String msg = START == 0L ? "" : Version.fullDescription();
        BrowserLog.jsStatus(BrowserLog.getMessage(msg));
    }

    @JSBody(params={"msg"}, script="console.log(msg);")
    public static native void jsLog(String var0);

    @JSBody(params={"msg"}, script="console.log(msg);var el = document.getElementById('status');if (el) { el.textContent = msg; }")
    public static native void jsStatus(String var0);
}

