/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.teavm.browser;

import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.teavm.PSystemBuilder2;
import net.sourceforge.plantuml.teavm.StringBounderTeaVM;
import net.sourceforge.plantuml.teavm.SvgGraphicsTeaVM;
import net.sourceforge.plantuml.teavm.UGraphicTeaVM;
import net.sourceforge.plantuml.teavm.browser.BrowserLog;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSFunctor;
import org.teavm.jso.JSObject;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Element;

public class PlantUMLBrowser {
    private static final StringBounder STRING_BOUNDER = new StringBounderTeaVM();
    private static final ColorMapper COLOR_MAPPER = ColorMapper.TEAVM;
    private static final HColor BACK = HColors.WHITE;
    private static final PSystemBuilder2 BUILDER = new PSystemBuilder2();
    private static final Object LOCK = new Object();
    private static volatile String[] pendingLines;
    private static volatile String pendingElementId;

    public static void main(String[] args) {
        new Thread(PlantUMLBrowser::workerLoop, "plantuml-render").start();
        PlantUMLBrowser.registerRender(PlantUMLBrowser::requestRender);
        BrowserLog.jsStatusDuration();
    }

    @JSBody(params={"cb"}, script="window.plantumlRender = cb;")
    private static native void registerRender(RenderCallback var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void requestRender(String[] lines, String elementId) {
        Object object = LOCK;
        synchronized (object) {
            pendingLines = lines;
            pendingElementId = elementId;
            LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void workerLoop() {
        while (true) {
            String elementId;
            String[] lines;
            Object object = LOCK;
            synchronized (object) {
                while (pendingLines == null) {
                    try {
                        LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                lines = pendingLines;
                elementId = pendingElementId;
                pendingLines = null;
            }
            PlantUMLBrowser.doRender(lines, elementId);
        }
    }

    private static void doRender(String[] lines, String elementId) {
        HTMLElement out = HTMLDocument.current().getElementById(elementId);
        if (out == null) {
            return;
        }
        try {
            BrowserLog.reset();
            BrowserLog.consoleLog(PlantUMLBrowser.class, "doRender");
            SvgGraphicsTeaVM svg = new SvgGraphicsTeaVM(900, 900);
            UGraphicTeaVM ug = UGraphicTeaVM.build(BACK, COLOR_MAPPER, STRING_BOUNDER, svg);
            BrowserLog.consoleLog(PlantUMLBrowser.class, "doRender wip10");
            Diagram diagram = BUILDER.createDiagram(lines);
            BrowserLog.consoleLog(PlantUMLBrowser.class, "doRender wip20");
            diagram.exportDiagramGraphic(ug, new FileFormatOption(FileFormat.SVG));
            BrowserLog.consoleLog(PlantUMLBrowser.class, "doRender wip30");
            PlantUMLBrowser.removeAllChildren(out);
            BrowserLog.consoleLog(PlantUMLBrowser.class, "doRender wip40");
            PlantUMLBrowser.appendSvgElement(out, svg.getSvgRoot());
            BrowserLog.consoleLog(PlantUMLBrowser.class, "doRender done");
            BrowserLog.jsStatusDuration();
        }
        catch (Exception e) {
            out.setTextContent(String.valueOf(e));
        }
    }

    @JSBody(params={"p", "svg"}, script="p.appendChild(svg);")
    private static native void appendSvgElement(HTMLElement var0, Element var1);

    @JSBody(params={"el"}, script="while(el.firstChild)el.removeChild(el.firstChild);")
    private static native void removeAllChildren(HTMLElement var0);

    @JSFunctor
    public static interface RenderCallback
    extends JSObject {
        public void call(String[] var1, String var2);
    }
}

