/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.teavm.browser;

import org.teavm.jso.JSBody;
import org.teavm.jso.JSFunctor;
import org.teavm.jso.JSObject;

public final class TeaVmScriptLoader {
    private static final Object LOCK = new Object();
    private static volatile boolean loadSuccess;
    private static volatile String loadError;
    private static volatile boolean loadComplete;

    @JSBody(params={"url", "onOk", "onErr"}, script="var w = window;w.__pl_script_state = w.__pl_script_state || Object.create(null);var st = w.__pl_script_state[url];if (st && st.state === 'loaded') { onOk(); return; }if (st && st.state === 'loading') { st.ok.push(onOk); st.err.push(onErr); return; }st = w.__pl_script_state[url] = { state: 'loading', ok: [onOk], err: [onErr] };var s = document.createElement('script');s.src = url;s.async = true;s.onload = function() {  st.state = 'loaded';  var list = st.ok; st.ok = []; st.err = [];  for (var i = 0; i < list.length; i++) list[i]();};s.onerror = function() {  st.state = 'error';  var list = st.err; st.ok = []; st.err = [];  for (var i = 0; i < list.length; i++) list[i]('Failed to load ' + url);};document.head.appendChild(s);")
    public static native void loadOnce(String var0, Ok var1, Err var2);

    @JSBody(params={"namespace", "path"}, script="var ns = window.PLANTUML_STDLIB && window.PLANTUML_STDLIB[namespace];return (ns && ns[path]) || null;")
    public static native JSObject getRaw(String var0, String var1);

    @JSBody(params={"lines"}, script="return lines.join('\\n');")
    public static native String joinLines(JSObject var0);

    @JSBody(params={"url"}, script="var st = window.__pl_script_state && window.__pl_script_state[url];return !!(st && st.state === 'loaded');")
    private static native boolean isLoaded(String var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadOnceSync(String url) {
        if (TeaVmScriptLoader.isLoaded(url)) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            loadComplete = false;
            loadSuccess = false;
            loadError = null;
            TeaVmScriptLoader.loadOnce(url, () -> {
                Object object = LOCK;
                synchronized (object) {
                    loadSuccess = true;
                    loadComplete = true;
                    LOCK.notify();
                }
            }, msg -> {
                Object object = LOCK;
                synchronized (object) {
                    loadSuccess = false;
                    loadError = msg;
                    loadComplete = true;
                    LOCK.notify();
                }
            });
            while (!loadComplete) {
                try {
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!loadSuccess) {
                throw new RuntimeException(loadError);
            }
        }
    }

    private TeaVmScriptLoader() {
    }

    @JSFunctor
    public static interface Ok
    extends JSObject {
        public void invoke();
    }

    @JSFunctor
    public static interface Err
    extends JSObject {
        public void invoke(String var1);
    }
}

