/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.expression;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.expression.Knowledge;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.expression.Token;
import net.sourceforge.plantuml.tim.expression.TokenIterator;
import net.sourceforge.plantuml.tim.expression.TokenStack;
import net.sourceforge.plantuml.tim.expression.TokenType;

public class ShuntingYard {
    private final TokenStack ouputQueue = new TokenStack();
    private final Deque<Token> operatorStack = new ArrayDeque<Token>();
    private static final boolean TRACE = false;
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9.$_]+");

    private void traceMe() {
    }

    public ShuntingYard(TokenIterator it, Knowledge knowledge, StringLocated location) throws EaterException {
        Token token;
        while (it.hasMoreTokens()) {
            token = it.nextToken();
            this.traceMe();
            if (token.getTokenType() == TokenType.NUMBER || token.getTokenType() == TokenType.QUOTED_STRING) {
                this.ouputQueue.add(token);
                continue;
            }
            if (token.getTokenType() == TokenType.FUNCTION_NAME) {
                this.operatorStack.addFirst(token);
                continue;
            }
            if (token.getTokenType() == TokenType.PLAIN_TEXT) {
                String name = token.getSurface();
                TValue variable = knowledge.getVariable(name);
                if (variable == null) {
                    if (!this.isVariableName(name)) {
                        throw new EaterException("Parsing syntax error about " + name, location);
                    }
                    this.ouputQueue.add(new Token(name, TokenType.QUOTED_STRING, null));
                    continue;
                }
                this.ouputQueue.add(variable.toToken());
                continue;
            }
            if (this.isOperatorOrAffectation(token)) {
                while ((this.thereIsAFunctionAtTheTopOfTheOperatorStack() || this.thereIsAnOperatorAtTheTopOfTheOperatorStackWithGreaterPrecedence(token) || this.theOperatorAtTheTopOfTheOperatorStackHasEqualPrecedenceAndIsLeftAssociative(token)) && this.theOperatorAtTheTopOfTheOperatorStackIsNotALeftParenthesis(token)) {
                    this.ouputQueue.add(this.operatorStack.removeFirst());
                }
                this.operatorStack.addFirst(token);
                continue;
            }
            if (token.getTokenType() == TokenType.OPEN_PAREN_FUNC) {
                this.operatorStack.addFirst(token);
                continue;
            }
            if (token.getTokenType() == TokenType.OPEN_PAREN_MATH) {
                this.operatorStack.addFirst(token);
                continue;
            }
            if (token.getTokenType() == TokenType.CLOSE_PAREN_FUNC) {
                while (this.operatorStack.peekFirst() != null && this.operatorStack.peekFirst().getTokenType() != TokenType.OPEN_PAREN_FUNC) {
                    this.ouputQueue.add(this.operatorStack.removeFirst());
                }
                Token first = this.operatorStack.removeFirst();
                this.ouputQueue.add(first);
                continue;
            }
            if (token.getTokenType() == TokenType.CLOSE_PAREN_MATH) {
                while (this.operatorStack.peekFirst().getTokenType() != TokenType.OPEN_PAREN_MATH) {
                    this.ouputQueue.add(this.operatorStack.removeFirst());
                }
                if (this.operatorStack.peekFirst().getTokenType() != TokenType.OPEN_PAREN_MATH) continue;
                this.operatorStack.removeFirst();
                continue;
            }
            if (token.getTokenType() == TokenType.COMMA) {
                while (this.operatorStack.peekFirst() != null && this.operatorStack.peekFirst().getTokenType() != TokenType.OPEN_PAREN_FUNC) {
                    this.ouputQueue.add(this.operatorStack.removeFirst());
                }
                continue;
            }
            throw new UnsupportedOperationException(token.toString());
        }
        while (!this.operatorStack.isEmpty()) {
            token = this.operatorStack.removeFirst();
            this.ouputQueue.add(token);
        }
    }

    private boolean isVariableName(String name) {
        return VARIABLE_NAME_PATTERN.matcher(name).matches();
    }

    private boolean thereIsAFunctionAtTheTopOfTheOperatorStack() {
        Token top = this.operatorStack.peekFirst();
        return top != null && top.getTokenType() == TokenType.FUNCTION_NAME;
    }

    private boolean thereIsAnOperatorAtTheTopOfTheOperatorStackWithGreaterPrecedence(Token token) {
        Token top = this.operatorStack.peekFirst();
        return top != null && this.isOperatorOrAffectation(top) && top.getPrecedence() > token.getPrecedence();
    }

    private boolean theOperatorAtTheTopOfTheOperatorStackHasEqualPrecedenceAndIsLeftAssociative(Token token) {
        Token top = this.operatorStack.peekFirst();
        return top != null && this.isOperatorOrAffectation(top) && top.getLeftAssociativity() && top.getPrecedence() == token.getPrecedence();
    }

    private boolean isOperatorOrAffectation(Token token) {
        return token.getTokenType() == TokenType.OPERATOR || token.getTokenType() == TokenType.AFFECTATION;
    }

    private boolean theOperatorAtTheTopOfTheOperatorStackIsNotALeftParenthesis(Token token) {
        Token top = this.operatorStack.peekFirst();
        if (top != null && top.getTokenType() == TokenType.OPEN_PAREN_MATH) {
            return true;
        }
        return true;
    }

    public TokenStack getQueue() {
        return this.ouputQueue;
    }
}

