/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.function.Supplier;
import net.sourceforge.plantuml.ProgressBar;
import net.sourceforge.plantuml.cli.GlobalConfig;
import net.sourceforge.plantuml.cli.GlobalConfigKey;
import net.sourceforge.plantuml.teavm.TeaVM;

public abstract class Log {
    private static final long start = System.currentTimeMillis();
    private static final String PERFLOG_FILENAME = "perflog.txt";
    private static boolean firstCall = true;

    private static String format(String s) {
        StringBuilder sb = new StringBuilder();
        if (!TeaVM.isTeaVM()) {
            long delta = System.currentTimeMillis() - start;
            long freeMemory = Runtime.getRuntime().freeMemory();
            long maxMemory = Runtime.getRuntime().maxMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            long usedMemory = totalMemory - freeMemory;
            int threadActiveCount = Thread.activeCount();
            sb.append("(");
            sb.append(delta / 1000L);
            sb.append(".");
            sb.append(String.format("%03d", delta % 1000L));
            sb.append(" - ");
            long total = totalMemory / 1024L / 1024L;
            long free = freeMemory / 1024L / 1024L;
            sb.append(total);
            sb.append(" Mo) ");
            sb.append(free);
            sb.append(" Mo - ");
            sb.append(s);
        }
        return sb.toString();
    }

    public static void println(Object s) {
    }

    public static synchronized void debug(Supplier<String> msgSupplier) {
    }

    public static synchronized void info(Supplier<String> msgSupplier) {
        if (!TeaVM.isTeaVM() && GlobalConfig.getInstance().boolValue(GlobalConfigKey.VERBOSE)) {
            ProgressBar.clear();
            System.err.println(Log.format(msgSupplier.get()));
        }
    }

    public static synchronized void error(String s) {
        if (!TeaVM.isTeaVM()) {
            ProgressBar.clear();
        }
        System.err.println(s);
    }

    public static void header(String s) {
    }

    public static void perflog(String line) {
    }

    public static void deletePerfLogFile() {
        File file;
        if (!TeaVM.isTeaVM() && (file = new File(PERFLOG_FILENAME)).exists() && !file.delete()) {
            Log.error("Cannot del perflog.txt");
        }
    }

    private static synchronized void perflogInternal(String line) {
        try {
            if (firstCall) {
                Log.deletePerfLogFile();
                firstCall = false;
            }
            try (FileWriter fw = new FileWriter(PERFLOG_FILENAME, true);
                 BufferedWriter bw = new BufferedWriter(fw);
                 PrintWriter out = new PrintWriter(bw);){
                out.println(line);
            }
        }
        catch (IOException e) {
            Log.error("Cannot write in perflog.txt : " + e.getMessage());
        }
    }

    public static synchronized void logStackTrace(String s) {
        if (!TeaVM.isTeaVM()) {
            if (firstCall) {
                Log.deletePerfLogFile();
                firstCall = false;
            }
            try (FileWriter fw = new FileWriter(PERFLOG_FILENAME, true);
                 PrintWriter pw = new PrintWriter(fw);){
                Exception e = new Exception("StackTrace " + s);
                e.fillInStackTrace();
                e.printStackTrace(pw);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

