/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.utils.SignatureUtils;

public class Version {
    public static String versionString() {
        return "1.2026.2";
    }

    public static String fullDescription() {
        return "PlantUML version " + Version.versionString() + " / N/A [" + Version.compileTimeString() + "]";
    }

    public static String versionString(int size) {
        StringBuilder sb = new StringBuilder(Version.versionString());
        while (sb.length() < size) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static int beta() {
        int x = "1.2026.2".indexOf("beta");
        if (x == -1) {
            return 0;
        }
        return Integer.parseInt("1.2026.2".substring(x + "beta".length()));
    }

    public static String etag() {
        return SignatureUtils.getMD5Hex("1.2026.2");
    }

    public static String turningId() {
        return Version.etag();
    }

    public static long compileTime() {
        return 1768736672346L;
    }

    public static String compileTimeString() {
        return Instant.ofEpochMilli(1772320591792L).atZone(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss 'UTC'"));
    }

    public static String getJarPath() {
        try {
            ClassLoader loader = Version.class.getClassLoader();
            if (loader == null) {
                return "No ClassLoader?";
            }
            SURL url = SURL.create(loader.getResource("net/sourceforge/plantuml/version/Version.class"));
            if (url == null) {
                return "No URL?";
            }
            String fullpath = url.toString();
            fullpath = fullpath.replaceAll("net/sourceforge/plantuml/version/Version\\.class", "");
            return fullpath;
        }
        catch (Throwable t) {
            Logme.error(t);
            return t.toString();
        }
    }
}

