# This file is generated by numpy's build process
# It contains system_info results at the time of building this package.
from enum import Enum
from numpy._core._multiarray_umath import (
    __cpu_features__,
    __cpu_baseline__,
    __cpu_dispatch__,
)

__all__ = ["show_config"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return {k: _cleanup(v) for k, v in d.items() if v and _cleanup(v)}
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "clang",
                "linker": r"ld.lld",
                "version": "21.0.0",
                "commands": r"x86_64-linux-android-clang",
                "args": r"-fstack-protector-strong, -Oz, -isystem/data/data/com.termux/files/usr/include/c++/v1, -isystem/data/data/com.termux/files/usr/include",
                "linker args": r"-L/data/data/com.termux/files/usr/lib, -Wl,-rpath=/data/data/com.termux/files/usr/lib, -Wl,--enable-new-dtags, -Wl,--as-needed, -Wl,-z,relro,-z,now, -Wl,--as-needed,-lpython3.13, -lm",
            },
            "cython": {
                "name": "cython",
                "linker": r"cython",
                "version": "3.0.12",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "clang",
                "linker": r"ld.lld",
                "version": "21.0.0",
                "commands": r"x86_64-linux-android-clang++",
                "args": r"-fstack-protector-strong, -Oz, -isystem/data/data/com.termux/files/usr/include/c++/v1, -isystem/data/data/com.termux/files/usr/include",
                "linker args": r"-L/data/data/com.termux/files/usr/lib, -Wl,-rpath=/data/data/com.termux/files/usr/lib, -Wl,--enable-new-dtags, -Wl,--as-needed, -Wl,-z,relro,-z,now, -Wl,--as-needed,-lpython3.13, -lm",
            },
        },
        "Machine Information": {
            "host": {
                "cpu": "x86_64",
                "family": "x86_64",
                "endian": "little",
                "system": "android",
            },
            "build": {
                "cpu": "x86_64",
                "family": "x86_64",
                "endian": "little",
                "system": "android",
            },
            "cross-compiled": bool("True".lower().replace("false", "")),
        },
        "Build Dependencies": {
            "blas": {
                "name": "openblas",
                "found": bool("True".lower().replace("false", "")),
                "version": "0.3.31",
                "detection method": "pkgconfig",
                "include directory": r"/data/data/com.termux/files/usr/include/openblas",
                "lib directory": r"/data/data/com.termux/files/usr/lib",
                "openblas configuration": r"USE_64BITINT= NO_CBLAS= NO_LAPACK= NO_LAPACKE= DYNAMIC_ARCH=OFF DYNAMIC_OLDER=OFF NO_AFFINITY=1 USE_OPENMP= CORE2 MAX_THREADS=0",
                "pc file directory": r"/data/data/com.termux/files/usr/lib/pkgconfig",
            },
            "lapack": {
                "name": "openblas",
                "found": bool("True".lower().replace("false", "")),
                "version": "0.3.31",
                "detection method": "pkgconfig",
                "include directory": r"/data/data/com.termux/files/usr/include/openblas",
                "lib directory": r"/data/data/com.termux/files/usr/lib",
                "openblas configuration": r"USE_64BITINT= NO_CBLAS= NO_LAPACK= NO_LAPACKE= DYNAMIC_ARCH=OFF DYNAMIC_OLDER=OFF NO_AFFINITY=1 USE_OPENMP= CORE2 MAX_THREADS=0",
                "pc file directory": r"/data/data/com.termux/files/usr/lib/pkgconfig",
            },
        },
        "Python Information": {
            "path": r"/home/builder/.termux-build/python3.13-crossenv-prefix-bionic-x86_64/cross/bin/python",
            "version": "3.13",
        },
        "SIMD Extensions": {
            "baseline": __cpu_baseline__,
            "found": [
                feature for feature in __cpu_dispatch__ if __cpu_features__[feature]
            ],
            "not found": [
                feature for feature in __cpu_dispatch__ if not __cpu_features__[feature]
            ],
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which NumPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    See Also
    --------
    get_include : Returns the directory containing NumPy C
                  header files.

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )


def show_config(mode=DisplayModes.stdout.value):
    return show(mode)


show_config.__doc__ = show.__doc__
show_config.__module__ = "numpy"
