# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "clang",
                "linker": r"ld.lld",
                "version": "21.0.0",
                "commands": r"x86_64-linux-android-clang",
                "args": r"-fstack-protector-strong, -Oz, -isystem/data/data/com.termux/files/usr/include/c++/v1, -isystem/data/data/com.termux/files/usr/include",
                "linker args": r"-L/data/data/com.termux/files/usr/lib, -Wl,-rpath=/data/data/com.termux/files/usr/lib, -Wl,--enable-new-dtags, -Wl,--as-needed, -Wl,-z,relro,-z,now, -Wl,--as-needed,-lpython3.12",
            },
            "cython": {
                "name": r"cython",
                "linker": r"cython",
                "version": r"3.2.4",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "clang",
                "linker": r"ld.lld",
                "version": "21.0.0",
                "commands": r"x86_64-linux-android-clang++",
                "args": r"-fstack-protector-strong, -Oz, -isystem/data/data/com.termux/files/usr/include/c++/v1, -isystem/data/data/com.termux/files/usr/include",
                "linker args": r"-L/data/data/com.termux/files/usr/lib, -Wl,-rpath=/data/data/com.termux/files/usr/lib, -Wl,--enable-new-dtags, -Wl,--as-needed, -Wl,-z,relro,-z,now, -Wl,--as-needed,-lpython3.12",
            },
            "fortran": {
                "name": "llvm-flang",
                "linker": r"ld.lld",
                "version": "21.0.0",
                "commands": r"x86_64-linux-android-flang-new",
                "args": r"",
                "linker args": r"-L/data/data/com.termux/files/usr/lib, -Wl,-rpath=/data/data/com.termux/files/usr/lib, -Wl,--enable-new-dtags, -Wl,--as-needed, -Wl,-z,relro,-z,now, -Wl,--as-needed,-lpython3.12",
            },
            "pythran": {
                "version": r"0.18.1",
                "include directory": r"../../../python3.12-crossenv-prefix-bionic-x86_64/build/lib/python3.12/site-packages/pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"android",
            },
            "build": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"linux",
            },
            "cross-compiled": bool("True".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "openblas",
                "found": bool("True".lower().replace('false', '')),
                "version": "0.3.31",
                "detection method": "pkgconfig",
                "include directory": r"/data/data/com.termux/files/usr/include/openblas",
                "lib directory": r"/data/data/com.termux/files/usr/lib",
                "openblas configuration": r"USE_64BITINT= NO_CBLAS= NO_LAPACK= NO_LAPACKE= DYNAMIC_ARCH=OFF DYNAMIC_OLDER=OFF NO_AFFINITY=1 USE_OPENMP= CORE2 MAX_THREADS=0",
                "pc file directory": r"/data/data/com.termux/files/usr/lib/pkgconfig",
                "has ilp64": bool(r"False".lower().replace('false', '')),
            },
            "lapack": {
                "name": "openblas",
                "found": bool("True".lower().replace('false', '')),
                "version": "0.3.31",
                "detection method": "pkgconfig",
                "include directory": r"/data/data/com.termux/files/usr/include/openblas",
                "lib directory": r"/data/data/com.termux/files/usr/lib",
                "openblas configuration": r"USE_64BITINT= NO_CBLAS= NO_LAPACK= NO_LAPACKE= DYNAMIC_ARCH=OFF DYNAMIC_OLDER=OFF NO_AFFINITY=1 USE_OPENMP= CORE2 MAX_THREADS=0",
                "pc file directory": r"/data/data/com.termux/files/usr/lib/pkgconfig",
                "has ilp64": bool(r"False".lower().replace('false', '')),
            },
            "pybind11": {
                "name": "pybind11",
                "version": "3.0.2",
                "detection method": "pkgconfig",
                "include directory": r"/data/data/com.termux/files/usr/include",
            },
        },
        "Python Information": {
            "path": r"/home/builder/.termux-build/python3.12-crossenv-prefix-bionic-x86_64/cross/bin/python",
            "version": "3.12",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Examples
    --------
    >>> import scipy
    >>> scipy.show_config()
    ... # formatted output is printed to the console

    >>> config_dict = scipy.show_config(mode='dicts')
    >>> list(config_dict.keys())
    ['Compilers', 'Machine Information', 'Build Dependencies', 'Python Information']

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
