# Building bdwgc with autoconf/automake

We support GNU-style builds based on `autoconf`, `automake` and `libtool`.
This is based almost entirely on _Tom Tromey_'s work with `gcj`.

Type the following to regenerate `configure` (if older than `configure.ac`):

```sh
./autogen.sh
```

Type the following to build, test and install the libraries:

```sh
./configure && make && make check && make install
```

The advantages of this process are:

  1. It should eventually do a better job of automatically determining the
     right compiler to use, etc.; it probably already does in some cases.

  2. It tries to automatically compute a good set of default bdwgc parameters
     for the platform (e.g. threads support); it provides an easier way to
     configure some of the other parameters.

  3. It integrates better with other projects using a GNU-style build process.

  4. It builds both dynamic and static libraries.

The known disadvantages are:

  1. The build scripts are much more complex, and harder to debug and
     understand (though they are largely standard); there might be some
     redundant stuff.

  2. It probably does not work on all UNIX-like platforms yet; it probably
     will never work on some other.

  3. The scripts might be not yet complete; some of the standard GNU targets
     might not work well yet.  (Corrections/additions are very welcome.)

The distribution should contain all files needed to run `configure` and
`make`, as well as the sources needed to regenerate the derived files.

Note that the distribution comes without `Makefile` which is generated by
`configure`.  The distribution also contains `Makefile.direct` which is not
always equivalent to the generated one.

Important options to configure:

  * `--prefix=PREFIX`: install architecture-independent files in `PREFIX`
    (`/usr/local` path by default on UNIX-like platforms).

  * `--exec-prefix=EPREFIX`: install architecture-dependent files in `EPREFIX`
    (same as `prefix` by default).

  * `--enable-threads=TYPE`: choose threading package.

  * `--disable-parallel-mark`: do not parallelize marking and free list
    construction.

  * `--enable-gc-debug`: include full support for pointer back-tracing, etc.

On UNIX-like platforms, unless `--prefix` is set (or `--exec-prefix`, or one
of the more obscure options), `make install` will install `libgc.a` and
`libgc.so` in `/usr/local/lib` and `/usr/local/bin`, respectively, which would
typically require the `make install` to be run as root.

It is not recommended to turn off parallel marking for multiprocessors unless
some issues exist with the feature on the target platform.
