/*
 * Copyright (C) 2015-2022 Ole André Vadla Ravnås <oleavr@nowsecure.com>
 *
 * Licence: wxWindows Library Licence, Version 3.1
 */

#ifndef __GUM_ARM_REG_H__
#define __GUM_ARM_REG_H__

#include <capstone.h>
#include <gum/gumdefs.h>

G_BEGIN_DECLS

typedef guint GumArmMetaReg;
typedef struct _GumArmRegInfo GumArmRegInfo;

enum _GumArmMetaReg
{
  GUM_ARM_MREG_R0,
  GUM_ARM_MREG_R1,
  GUM_ARM_MREG_R2,
  GUM_ARM_MREG_R3,
  GUM_ARM_MREG_R4,
  GUM_ARM_MREG_R5,
  GUM_ARM_MREG_R6,
  GUM_ARM_MREG_R7,
  GUM_ARM_MREG_R8,
  GUM_ARM_MREG_R9,
  GUM_ARM_MREG_R10,
  GUM_ARM_MREG_R11,
  GUM_ARM_MREG_R12,
  GUM_ARM_MREG_R13,
  GUM_ARM_MREG_R14,
  GUM_ARM_MREG_R15,

  GUM_ARM_MREG_S0,
  GUM_ARM_MREG_S1,
  GUM_ARM_MREG_S2,
  GUM_ARM_MREG_S3,
  GUM_ARM_MREG_S4,
  GUM_ARM_MREG_S5,
  GUM_ARM_MREG_S6,
  GUM_ARM_MREG_S7,
  GUM_ARM_MREG_S8,
  GUM_ARM_MREG_S9,
  GUM_ARM_MREG_S10,
  GUM_ARM_MREG_S11,
  GUM_ARM_MREG_S12,
  GUM_ARM_MREG_S13,
  GUM_ARM_MREG_S14,
  GUM_ARM_MREG_S15,
  GUM_ARM_MREG_S16,
  GUM_ARM_MREG_S17,
  GUM_ARM_MREG_S18,
  GUM_ARM_MREG_S19,
  GUM_ARM_MREG_S20,
  GUM_ARM_MREG_S21,
  GUM_ARM_MREG_S22,
  GUM_ARM_MREG_S23,
  GUM_ARM_MREG_S24,
  GUM_ARM_MREG_S25,
  GUM_ARM_MREG_S26,
  GUM_ARM_MREG_S27,
  GUM_ARM_MREG_S28,
  GUM_ARM_MREG_S29,
  GUM_ARM_MREG_S30,
  GUM_ARM_MREG_S31,

  GUM_ARM_MREG_D0,
  GUM_ARM_MREG_D1,
  GUM_ARM_MREG_D2,
  GUM_ARM_MREG_D3,
  GUM_ARM_MREG_D4,
  GUM_ARM_MREG_D5,
  GUM_ARM_MREG_D6,
  GUM_ARM_MREG_D7,
  GUM_ARM_MREG_D8,
  GUM_ARM_MREG_D9,
  GUM_ARM_MREG_D10,
  GUM_ARM_MREG_D11,
  GUM_ARM_MREG_D12,
  GUM_ARM_MREG_D13,
  GUM_ARM_MREG_D14,
  GUM_ARM_MREG_D15,
  GUM_ARM_MREG_D16,
  GUM_ARM_MREG_D17,
  GUM_ARM_MREG_D18,
  GUM_ARM_MREG_D19,
  GUM_ARM_MREG_D20,
  GUM_ARM_MREG_D21,
  GUM_ARM_MREG_D22,
  GUM_ARM_MREG_D23,
  GUM_ARM_MREG_D24,
  GUM_ARM_MREG_D25,
  GUM_ARM_MREG_D26,
  GUM_ARM_MREG_D27,
  GUM_ARM_MREG_D28,
  GUM_ARM_MREG_D29,
  GUM_ARM_MREG_D30,
  GUM_ARM_MREG_D31,

  GUM_ARM_MREG_Q0,
  GUM_ARM_MREG_Q1,
  GUM_ARM_MREG_Q2,
  GUM_ARM_MREG_Q3,
  GUM_ARM_MREG_Q4,
  GUM_ARM_MREG_Q5,
  GUM_ARM_MREG_Q6,
  GUM_ARM_MREG_Q7,
  GUM_ARM_MREG_Q8,
  GUM_ARM_MREG_Q9,
  GUM_ARM_MREG_Q10,
  GUM_ARM_MREG_Q11,
  GUM_ARM_MREG_Q12,
  GUM_ARM_MREG_Q13,
  GUM_ARM_MREG_Q14,
  GUM_ARM_MREG_Q15,

  GUM_ARM_MREG_SP = GUM_ARM_MREG_R13,
  GUM_ARM_MREG_LR = GUM_ARM_MREG_R14,

  GUM_ARM_MREG_PC = GUM_ARM_MREG_R15
};

struct _GumArmRegInfo
{
  GumArmMetaReg meta;
  guint width;
  guint index;
};

GUM_API void gum_arm_reg_describe (arm_reg reg, GumArmRegInfo * ri);

G_END_DECLS

#endif
