/* frida-base-1.0.vapi generated by valac-0.58 0.58.0-frida, do not modify. */

[CCode (gir_namespace = "FridaBase", gir_version = "1.0")]
namespace Frida {
	namespace FS {
		[CCode (cheader_filename = "frida-base.h")]
		public static void mkdirp (GLib.File dir, GLib.Cancellable? cancellable = null) throws Frida.Error;
		[CCode (cheader_filename = "frida-base.h")]
		public static async GLib.Bytes read_all_bytes (GLib.File f, GLib.Cancellable? cancellable) throws Frida.Error, GLib.IOError;
		[CCode (cheader_filename = "frida-base.h")]
		public static async string read_all_text (GLib.File f, GLib.Cancellable? cancellable) throws Frida.Error, GLib.IOError;
		[CCode (cheader_filename = "frida-base.h")]
		public static void rmtree (GLib.File dir, GLib.Cancellable? cancellable = null) throws Frida.Error;
		[CCode (cheader_filename = "frida-base.h")]
		public static async void rmtree_async (GLib.File dir, GLib.Cancellable? cancellable = null) throws Frida.Error, GLib.IOError;
		[CCode (cheader_filename = "frida-base.h")]
		public static async void write_all_bytes (GLib.File f, GLib.Bytes b, GLib.Cancellable? cancellable) throws Frida.Error, GLib.IOError;
		[CCode (cheader_filename = "frida-base.h")]
		public static async void write_all_text (GLib.File f, string t, GLib.Cancellable? cancellable) throws Frida.Error, GLib.IOError;
	}
	namespace Marshal {
		[CCode (cheader_filename = "frida-base.h")]
		public static T enum_from_nick<T> (string nick) throws Frida.Error;
		[CCode (cheader_filename = "frida-base.h")]
		public static string enum_to_nick<T> (int val);
	}
	namespace MemoryFileDescriptor {
		[CCode (cheader_filename = "frida-base.h")]
		public static Frida.FileDescriptor from_bytes (string name, GLib.Bytes bytes);
		[CCode (cheader_filename = "frida-base.h")]
		public static bool is_supported ();
	}
	namespace Numeric {
		[CCode (cheader_filename = "frida-base.h")]
		public static bool int64_equal (int64? val_a, int64? val_b);
		[CCode (cheader_filename = "frida-base.h")]
		public static uint int64_hash (int64? val);
		[CCode (cheader_filename = "frida-base.h")]
		public static bool uint64_equal (uint64? val_a, uint64? val_b);
		[CCode (cheader_filename = "frida-base.h")]
		public static uint uint64_hash (uint64? val);
	}
	namespace ObjectPath {
		[CCode (cheader_filename = "frida-base.h")]
		public const string AGENT_CONTROLLER;
		[CCode (cheader_filename = "frida-base.h")]
		public const string AGENT_MESSAGE_SINK;
		[CCode (cheader_filename = "frida-base.h")]
		public const string AGENT_SESSION;
		[CCode (cheader_filename = "frida-base.h")]
		public const string AGENT_SESSION_PROVIDER;
		[CCode (cheader_filename = "frida-base.h")]
		public const string AUTHENTICATION_SERVICE;
		[CCode (cheader_filename = "frida-base.h")]
		public const string BUS_SESSION;
		[CCode (cheader_filename = "frida-base.h")]
		public const string CHANNEL;
		[CCode (cheader_filename = "frida-base.h")]
		public const string HOST_SESSION;
		[CCode (cheader_filename = "frida-base.h")]
		public const string PORTAL_SESSION;
		[CCode (cheader_filename = "frida-base.h")]
		public const string SERVICE;
		[CCode (cheader_filename = "frida-base.h")]
		public const string TRANSPORT_BROKER;
		[CCode (cheader_filename = "frida-base.h")]
		public static string for_agent_message_sink (Frida.AgentSessionId id);
		[CCode (cheader_filename = "frida-base.h")]
		public static string for_agent_session (Frida.AgentSessionId id);
		[CCode (cheader_filename = "frida-base.h")]
		public static string for_channel (Frida.ChannelId id);
		[CCode (cheader_filename = "frida-base.h")]
		public static string for_service_session (Frida.ServiceSessionId id);
	}
	namespace PeerConnection {
		[CCode (cheader_filename = "frida-base.h")]
		public static string compute_certificate_fingerprint (uint8[] cert_der);
		[CCode (cheader_filename = "frida-base.h")]
		public static async void configure_agent (Nice.Agent agent, uint stream_id, uint component_id, Frida.PeerOptions? options, GLib.Cancellable? cancellable) throws Frida.Error, GLib.IOError;
	}
	namespace PeerSessionId {
		[CCode (cheader_filename = "frida-base.h")]
		public static uint64 generate ();
	}
	namespace ServerGuid {
		[CCode (cheader_filename = "frida-base.h")]
		public const string HOST_SESSION_SERVICE;
	}
	namespace Tcp {
		[CCode (cheader_filename = "frida-base.h")]
		public static void enable_nodelay (GLib.Socket socket);
	}
	namespace Udp {
		[CCode (cheader_filename = "frida-base.h")]
		public static size_t recv (uint8[] data, GLib.DatagramBased source, GLib.Cancellable? cancellable, out GLib.InetSocketAddress remote_address) throws Frida.Error, GLib.IOError;
		[CCode (cheader_filename = "frida-base.h")]
		public static void send (uint8[] data, GLib.DatagramBased sink, GLib.Cancellable? cancellable) throws Frida.Error, GLib.IOError;
		[CCode (cheader_filename = "frida-base.h")]
		public static void send_to (uint8[] data, GLib.InetSocketAddress? dest_addr, GLib.DatagramBased sink, GLib.Cancellable? cancellable) throws Frida.Error, GLib.IOError;
	}
	namespace UnixSocket {
		[CCode (cheader_filename = "frida-base.h")]
		public static void tune_buffer_sizes (int fd);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class AgentMessageTransmitter : GLib.Object {
		public AgentMessageTransmitter (Frida.AgentSession agent_session, uint persist_timeout, GLib.MainContext frida_context, GLib.MainContext dbus_context);
		public void add_candidates (string[] candidate_sdps) throws Frida.Error;
		public void begin_migration ();
		public void check_okay_to_receive () throws Frida.Error;
		public async void close (GLib.Cancellable? cancellable) throws GLib.IOError;
		public void commit_migration ();
		public void interrupt () throws Frida.Error;
		public void notify_candidate_gathering_done () throws Frida.Error;
		public void notify_rx_batch_id (uint batch_id) throws Frida.Error;
		public async void offer_peer_connection (string offer_sdp, GLib.HashTable<string,GLib.Variant> peer_options, GLib.Cancellable? cancellable, out string answer_sdp) throws Frida.Error, GLib.IOError;
		public void post_message_from_debugger (Frida.AgentScriptId script_id, string message);
		public void post_message_from_script (Frida.AgentScriptId script_id, string json, GLib.Bytes? data);
		public void resume (uint rx_batch_id, out uint tx_batch_id) throws Frida.Error;
		protected void schedule_on_dbus_thread (owned GLib.SourceFunc function);
		protected void schedule_on_frida_thread (owned GLib.SourceFunc function);
		public weak Frida.AgentSession agent_session { get; construct; }
		public GLib.MainContext dbus_context { get; construct; }
		public GLib.MainContext frida_context { get; construct; }
		public Frida.AgentMessageSink? message_sink { get; set; }
		public uint persist_timeout { get; construct; }
		public signal void candidate_gathering_done ();
		public signal void closed ();
		public signal void new_candidates (string[] candidate_sdps);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class ApplicationQueryOptions : GLib.Object {
		public ApplicationQueryOptions ();
		public static Frida.ApplicationQueryOptions _deserialize (GLib.HashTable<string,GLib.Variant> dict) throws Frida.Error;
		public GLib.HashTable<string,GLib.Variant> _serialize ();
		public void enumerate_selected_identifiers (GLib.Func<string> func);
		public bool has_selected_identifiers ();
		public void select_identifier (string identifier);
		public Frida.Scope scope { get; set; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class Buffer : GLib.Object {
		public Buffer (GLib.Bytes bytes, GLib.ByteOrder byte_order = HOST, uint pointer_size = (uint) sizeof (size_t));
		public GLib.Bytes read_bytes (size_t offset, size_t size);
		public double read_double (size_t offset);
		public string read_fixed_string (size_t offset, size_t size) throws Frida.Error;
		public float read_float (size_t offset);
		public int16 read_int16 (size_t offset);
		public int32 read_int32 (size_t offset);
		public int64 read_int64 (size_t offset);
		public int8 read_int8 (size_t offset);
		public uint64 read_pointer (size_t offset);
		public string read_string (size_t offset) throws Frida.Error;
		public uint16 read_uint16 (size_t offset);
		public uint32 read_uint32 (size_t offset);
		public uint64 read_uint64 (size_t offset);
		public uint8 read_uint8 (size_t offset);
		public unowned Frida.Buffer write_bytes (size_t offset, GLib.Bytes bytes);
		public unowned Frida.Buffer write_int16 (size_t offset, int16 val);
		public unowned Frida.Buffer write_int32 (size_t offset, int32 val);
		public unowned Frida.Buffer write_int64 (size_t offset, int64 val);
		public unowned Frida.Buffer write_int8 (size_t offset, int8 val);
		public void write_pointer (size_t offset, uint64 val);
		public unowned Frida.Buffer write_string (size_t offset, string val);
		public unowned Frida.Buffer write_uint16 (size_t offset, uint16 val);
		public unowned Frida.Buffer write_uint32 (size_t offset, uint32 val);
		public unowned Frida.Buffer write_uint64 (size_t offset, uint64 val);
		public unowned Frida.Buffer write_uint8 (size_t offset, uint8 val);
		public GLib.ByteOrder byte_order { get; construct; }
		public GLib.Bytes bytes { get; construct; }
		public uint pointer_size { get; construct; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class BufferBuilder : GLib.Object {
		public BufferBuilder (GLib.ByteOrder byte_order = HOST, uint pointer_size = (uint) sizeof (size_t));
		public uint64 address_of (string label) throws Frida.Error;
		public unowned Frida.BufferBuilder align (size_t n);
		public unowned Frida.BufferBuilder append_bytes (GLib.Bytes bytes);
		public unowned Frida.BufferBuilder append_data (uint8[] data);
		public unowned Frida.BufferBuilder append_double (double val);
		public unowned Frida.BufferBuilder append_float (float val);
		public unowned Frida.BufferBuilder append_int16 (int16 val);
		public unowned Frida.BufferBuilder append_int32 (int32 val);
		public unowned Frida.BufferBuilder append_int64 (int64 val);
		public unowned Frida.BufferBuilder append_int8 (int8 val);
		public unowned Frida.BufferBuilder append_label (string name) throws Frida.Error;
		public unowned Frida.BufferBuilder append_pointer (uint64 val);
		public unowned Frida.BufferBuilder append_pointer_to_label (string name);
		public unowned Frida.BufferBuilder append_pointer_to_label_if (bool present, string name);
		public unowned Frida.BufferBuilder append_size (uint64 val);
		public unowned Frida.BufferBuilder append_string (string val, Frida.StringTerminator terminator = NUL);
		public unowned Frida.BufferBuilder append_uint16 (uint16 val);
		public unowned Frida.BufferBuilder append_uint32 (uint32 val);
		public unowned Frida.BufferBuilder append_uint64 (uint64 val);
		public unowned Frida.BufferBuilder append_uint8 (uint8 val);
		public GLib.Bytes build (uint64 base_address = 0);
		public unowned Frida.BufferBuilder seek (size_t offset);
		public unowned Frida.BufferBuilder skip (size_t n);
		public GLib.Bytes try_build (uint64 base_address = 0) throws Frida.Error;
		public unowned Frida.BufferBuilder write_bytes (size_t offset, GLib.Bytes bytes);
		public unowned Frida.BufferBuilder write_data (size_t offset, uint8[] data);
		public unowned Frida.BufferBuilder write_double (size_t offset, double val);
		public unowned Frida.BufferBuilder write_float (size_t offset, float val);
		public unowned Frida.BufferBuilder write_int16 (size_t offset, int16 val);
		public unowned Frida.BufferBuilder write_int32 (size_t offset, int32 val);
		public unowned Frida.BufferBuilder write_int64 (size_t offset, int64 val);
		public unowned Frida.BufferBuilder write_int8 (size_t offset, int8 val);
		public unowned Frida.BufferBuilder write_pointer (size_t offset, uint64 val);
		public unowned Frida.BufferBuilder write_size (size_t offset, uint64 val);
		public unowned Frida.BufferBuilder write_string (size_t offset, string val);
		public unowned Frida.BufferBuilder write_uint16 (size_t offset, uint16 val);
		public unowned Frida.BufferBuilder write_uint32 (size_t offset, uint32 val);
		public unowned Frida.BufferBuilder write_uint64 (size_t offset, uint64 val);
		public unowned Frida.BufferBuilder write_uint8 (size_t offset, uint8 val);
		public GLib.ByteOrder byte_order { get; construct; }
		public size_t offset { get; }
		public uint pointer_size { get; construct; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class BufferReader {
		public BufferReader (Frida.Buffer buf);
		public GLib.Bytes read_bytes (size_t size) throws Frida.Error;
		public double read_double () throws Frida.Error;
		public string read_fixed_string (size_t size) throws Frida.Error;
		public float read_float () throws Frida.Error;
		public int16 read_int16 () throws Frida.Error;
		public int32 read_int32 () throws Frida.Error;
		public int64 read_int64 () throws Frida.Error;
		public int8 read_int8 () throws Frida.Error;
		public uint64 read_pointer (size_t offset) throws Frida.Error;
		public string read_string () throws Frida.Error;
		public uint16 read_uint16 () throws Frida.Error;
		public uint32 read_uint32 () throws Frida.Error;
		public uint64 read_uint64 () throws Frida.Error;
		public uint8 read_uint8 () throws Frida.Error;
		public unowned Frida.BufferReader skip (size_t n) throws Frida.Error;
		public size_t available { get; }
		public size_t offset { get; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class ChannelEndpoint : GLib.Object, Frida.Channel {
		public ChannelEndpoint (GLib.IOStream stream);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class ChannelRegistry : GLib.Object {
		public ChannelRegistry ();
		public void clear ();
		public GLib.IOStream link (Frida.ChannelId id) throws Frida.Error;
		public void register (Frida.ChannelId id, GLib.IOStream stream);
		public void unlink (Frida.ChannelId id);
		public signal void channel_closed (Frida.ChannelId id);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class ChannelStream : Frida.VirtualStream {
		public ChannelStream (Frida.Channel channel);
		public void abandon ();
		protected override void handle_close ();
		protected override GLib.IOCondition query_events ();
		public override ssize_t read (uint8[] buffer) throws GLib.IOError;
		public override ssize_t write (uint8[] buffer) throws GLib.IOError;
		public Frida.Channel channel { get; construct; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class DynamicInterface : GLib.Object {
		public DynamicInterface (string name, GLib.InetAddress ip);
		public GLib.InetAddress ip { get; construct; }
		public string name { get; construct; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class EndpointParameters : GLib.Object {
		public EndpointParameters (string? address = null, uint16 port = 0, GLib.TlsCertificate? certificate = null, string? origin = null, Frida.AuthenticationService? auth_service = null, GLib.File? asset_root = null);
		public string? address { get; construct; }
		public GLib.File? asset_root { get; set; }
		public Frida.AuthenticationService? auth_service { get; construct; }
		public GLib.TlsCertificate? certificate { get; construct; }
		public string? origin { get; construct; }
		public uint16 port { get; construct; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public class FileDescriptor : GLib.Object, GLib.FileDescriptorBased {
		public int handle;
		public FileDescriptor (int handle);
		public int steal ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class FrontmostQueryOptions : GLib.Object {
		public FrontmostQueryOptions ();
		public static Frida.FrontmostQueryOptions _deserialize (GLib.HashTable<string,GLib.Variant> dict) throws Frida.Error;
		public GLib.HashTable<string,GLib.Variant> _serialize ();
		public Frida.Scope scope { get; set; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class JsonObjectBuilder : GLib.Object, Frida.ObjectBuilder {
		public JsonObjectBuilder ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class JsonObjectReader : GLib.Object, Frida.ObjectReader {
		public JsonObjectReader (string json) throws Frida.Error;
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class NullAuthenticationService : GLib.Object, Frida.AuthenticationService {
		public NullAuthenticationService ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class PeerOptions : GLib.Object {
		public PeerOptions ();
		public static Frida.PeerOptions _deserialize (GLib.HashTable<string,GLib.Variant> dict) throws Frida.Error;
		public GLib.HashTable<string,GLib.Variant> _serialize ();
		public void add_relay (Frida.Relay relay);
		public void clear_relays ();
		public void enumerate_relays (GLib.Func<Frida.Relay> func);
		public string? stun_server { get; set; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public class PeerSessionDescription {
		public string? fingerprint;
		public string? ice_pwd;
		public bool ice_trickle;
		public string? ice_ufrag;
		public size_t max_message_size;
		public uint16 sctp_port;
		public uint64 session_id;
		public Frida.PeerSetup setup;
		public PeerSessionDescription ();
		public static Frida.PeerSessionDescription parse (string sdp) throws Frida.Error;
		public string to_sdp ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class PeerSocket : GLib.Object, GLib.DatagramBased {
		public PeerSocket (Nice.Agent agent, uint stream_id, uint component_id);
		public virtual GLib.IOCondition datagram_condition_check (GLib.IOCondition condition);
		public virtual bool datagram_condition_wait (GLib.IOCondition condition, int64 timeout, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual GLib.DatagramBasedSource datagram_create_source (GLib.IOCondition condition, GLib.Cancellable? cancellable);
		public virtual int datagram_receive_messages (GLib.InputMessage[] messages, int flags, int64 timeout, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual int datagram_send_messages (GLib.OutputMessage[] messages, int flags, int64 timeout, GLib.Cancellable? cancellable) throws GLib.Error;
		public void register_source (GLib.Source source, GLib.IOCondition condition);
		public void unregister_source (GLib.Source source);
		public Nice.Agent agent { get; construct; }
		public uint component_id { get; construct; }
		public GLib.MainContext? main_context { get; construct; }
		public GLib.IOCondition pending_io { get; }
		public uint stream_id { get; construct; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class PidFileDescriptor : Frida.FileDescriptor {
		public static Frida.PidFileDescriptor from_pid (uint pid) throws Frida.Error;
		public Frida.FileDescriptor getfd (int targetfd) throws Frida.Error;
		public static bool getfd_is_supported ();
		public static bool is_supported ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class PortalOptions : GLib.Object {
		public PortalOptions ();
		public static Frida.PortalOptions _deserialize (GLib.HashTable<string,GLib.Variant> dict) throws Frida.Error;
		public GLib.HashTable<string,GLib.Variant> _serialize ();
		public string[]? acl { get; set; }
		public GLib.TlsCertificate? certificate { get; set; }
		public string? token { get; set; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class ProcessQueryOptions : GLib.Object {
		public ProcessQueryOptions ();
		public static Frida.ProcessQueryOptions _deserialize (GLib.HashTable<string,GLib.Variant> dict) throws Frida.Error;
		public GLib.HashTable<string,GLib.Variant> _serialize ();
		public void enumerate_selected_pids (GLib.Func<uint> func);
		public bool has_selected_pids ();
		public void select_pid (uint pid);
		public Frida.Scope scope { get; set; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class Promise<T> {
		public Promise ();
		public void reject (GLib.Error error);
		public void resolve (T result);
		public Frida.Future<T> future { get; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class Relay : GLib.Object {
		public Relay (string address, string username, string password, Frida.RelayKind kind);
		public string address { get; construct; }
		public Frida.RelayKind kind { get; construct; }
		public string password { get; construct; }
		public string username { get; construct; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class RpcClient : GLib.Object {
		public RpcClient (Frida.RpcPeer peer);
		public async Json.Node call (string method, Json.Node[] args, GLib.Bytes? data, GLib.Cancellable? cancellable) throws Frida.Error, GLib.IOError;
		public bool try_handle_message (string json);
		public weak Frida.RpcPeer peer { get; construct; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class ScriptOptions : GLib.Object {
		public ScriptOptions ();
		public static Frida.ScriptOptions _deserialize (GLib.HashTable<string,GLib.Variant> dict) throws Frida.Error;
		public GLib.HashTable<string,GLib.Variant> _serialize ();
		public string? name { get; set; }
		public Frida.ScriptRuntime runtime { get; set; }
		public GLib.Bytes? snapshot { get; set; }
		public Frida.SnapshotTransport snapshot_transport { get; set; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class SctpConnection : Frida.VirtualStream {
		public SctpConnection (GLib.DatagramBased transport_socket, Frida.PeerSetup setup, uint16 port, size_t max_message_size);
		public static void _close (void* sock);
		protected void _connect_sctp_socket (void* sock, uint16 port);
		protected void* _create_sctp_socket ();
		protected int _emit_transport_packet (uint8[] data);
		protected void _handle_transport_packet (uint8[] data);
		protected static void _initialize_sctp_backend ();
		protected void _on_sctp_socket_events_changed ();
		protected static GLib.IOCondition _query_sctp_socket_events (void* sock);
		protected static ssize_t _recv (void* sock, uint8[] buffer, out uint16 stream_id, out Frida.PayloadProtocolId protocol_id, out Frida.SctpMessageFlags message_flags) throws GLib.IOError;
		protected static ssize_t _send (void* sock, uint16 stream_id, Frida.PayloadProtocolId protocol_id, uint8[] data) throws GLib.IOError;
		public static void _shutdown (void* sock, Frida.SctpShutdownType type) throws GLib.IOError;
		protected override void handle_close ();
		protected override GLib.IOCondition query_events ();
		protected override Frida.VirtualStream.State query_initial_state ();
		public override ssize_t read (uint8[] buffer) throws GLib.IOError;
		public override void shutdown_read () throws GLib.IOError;
		public override void shutdown_write () throws GLib.IOError;
		protected override void update_pending_io ();
		public override ssize_t write (uint8[] buffer) throws GLib.IOError;
		public size_t max_message_size { get; construct; }
		public uint16 port { get; construct; }
		public Frida.PeerSetup setup { get; construct; }
		public GLib.DatagramBased transport_socket { get; construct; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class ServiceSessionRegistry : GLib.Object {
		public ServiceSessionRegistry ();
		public void clear ();
		public Frida.ServiceSession link (Frida.ServiceSessionId id) throws Frida.Error;
		public void register (Frida.ServiceSessionId id, Frida.ServiceSession session);
		public void unlink (Frida.ServiceSessionId id);
		public signal void session_closed (Frida.ServiceSessionId id);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class SessionOptions : GLib.Object {
		public SessionOptions ();
		public static Frida.SessionOptions _deserialize (GLib.HashTable<string,GLib.Variant> dict) throws Frida.Error;
		public GLib.HashTable<string,GLib.Variant> _serialize ();
		public string? emulated_agent_path { get; set; }
		public uint persist_timeout { get; set; }
		public Frida.Realm realm { get; set; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class SnapshotOptions : GLib.Object {
		public SnapshotOptions ();
		public static Frida.SnapshotOptions _deserialize (GLib.HashTable<string,GLib.Variant> dict) throws Frida.Error;
		public GLib.HashTable<string,GLib.Variant> _serialize ();
		public Frida.ScriptRuntime runtime { get; set; }
		public string? warmup_script { get; set; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class StaticAuthenticationService : GLib.Object, Frida.AuthenticationService {
		public StaticAuthenticationService (string token);
		public string token_hash { get; construct; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class UnauthorizedBusSession : GLib.Object, Frida.BusSession {
		public UnauthorizedBusSession ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class UnauthorizedHostSession : GLib.Object, Frida.HostSession {
		public UnauthorizedHostSession ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class UnauthorizedPortalSession : GLib.Object, Frida.PortalSession {
		public UnauthorizedPortalSession ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class VariantReader : GLib.Object, Frida.ObjectReader {
		public VariantReader (GLib.Variant v);
		public GLib.Variant current_object { get; }
		public GLib.Variant root_object { get; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public abstract class VirtualStream : GLib.IOStream {
		protected enum State {
			CREATED,
			OPENING,
			OPEN,
			CLOSED
		}
		protected delegate void WorkFunc ();
		protected GLib.Cancellable io_cancellable;
		protected GLib.MainContext main_context;
		protected Frida.VirtualStream.State state;
		protected VirtualStream ();
		public override bool close (GLib.Cancellable? cancellable) throws GLib.IOError;
		public override async bool close_async (int io_priority, GLib.Cancellable? cancellable) throws GLib.IOError;
		public override void dispose ();
		protected abstract void handle_close ();
		protected abstract GLib.IOCondition query_events ();
		protected virtual Frida.VirtualStream.State query_initial_state ();
		public abstract ssize_t read (uint8[] buffer) throws GLib.IOError;
		public void register_source (GLib.Source source, GLib.IOCondition condition);
		public virtual void shutdown_read () throws GLib.IOError;
		public virtual void shutdown_write () throws GLib.IOError;
		public void unregister_source (GLib.Source source);
		protected virtual void update_pending_io ();
		protected void with_state_lock (Frida.VirtualStream.WorkFunc func);
		public abstract ssize_t write (uint8[] buffer) throws GLib.IOError;
		public override GLib.InputStream input_stream { get; }
		public override GLib.OutputStream output_stream { get; }
		public GLib.IOCondition pending_io { get; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	public sealed class WebService : GLib.Object {
		public WebService (Frida.EndpointParameters endpoint_params, Frida.WebServiceFlavor flavor, Frida.PortConflictBehavior on_port_conflict = FAIL, Frida.DynamicInterfaceObserver? dynif_observer = null);
		public async void start (GLib.Cancellable? cancellable) throws Frida.Error, GLib.IOError;
		public void stop ();
		public Frida.DynamicInterfaceObserver? dynamic_interface_observer { get; construct; }
		public Frida.EndpointParameters endpoint_params { get; construct; }
		public Frida.WebServiceFlavor flavor { get; construct; }
		public GLib.SocketAddress? listen_address { get; }
		public Frida.PortConflictBehavior on_port_conflict { get; construct; }
		public signal void incoming (GLib.IOStream connection, GLib.SocketAddress remote_address, Frida.DynamicInterface? dynamic_iface);
	}
	[CCode (cheader_filename = "frida-base.h")]
	[DBus (name = "re.frida.AgentController17")]
	public interface AgentController : GLib.Object {
		public abstract async void acknowledge_spawn (Frida.HostChildInfo info, Frida.SpawnStartState start_state, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void cancel_exec (uint pid, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void prepare_to_exec (Frida.HostChildInfo info, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Frida.HostChildId prepare_to_fork (uint parent_pid, GLib.Cancellable? cancellable, out uint parent_injectee_id, out uint child_injectee_id, out GLib.Socket child_socket) throws GLib.Error;
		public abstract async Frida.HostChildId prepare_to_specialize (uint pid, string identifier, GLib.Cancellable? cancellable, out uint specialized_injectee_id, out string specialized_pipe_address) throws GLib.Error;
		public abstract async void recreate_agent_thread (uint pid, uint injectee_id, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void wait_for_permission_to_resume (Frida.HostChildId id, Frida.HostChildInfo info, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "frida-base.h")]
	[DBus (name = "re.frida.AgentMessageSink17")]
	public interface AgentMessageSink : GLib.Object {
		public abstract async void post_messages (Frida.AgentMessage[] messages, uint batch_id, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "frida-base.h")]
	[DBus (name = "re.frida.AgentSession17")]
	public interface AgentSession : GLib.Object {
		public abstract async void add_candidates (string[] candidate_sdps, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void begin_migration (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void close (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void commit_migration (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async uint8[] compile_script (string source, GLib.HashTable<string,GLib.Variant> options, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Frida.AgentScriptId create_script (string source, GLib.HashTable<string,GLib.Variant> options, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Frida.AgentScriptId create_script_from_bytes (uint8[] bytes, GLib.HashTable<string,GLib.Variant> options, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void destroy_script (Frida.AgentScriptId script_id, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void disable_child_gating (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void disable_debugger (Frida.AgentScriptId script_id, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void enable_child_gating (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void enable_debugger (Frida.AgentScriptId script_id, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void eternalize_script (Frida.AgentScriptId script_id, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void interrupt (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Frida.PortalMembershipId join_portal (string address, GLib.HashTable<string,GLib.Variant> options, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void leave_portal (Frida.PortalMembershipId membership_id, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void load_script (Frida.AgentScriptId script_id, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void notify_candidate_gathering_done (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void offer_peer_connection (string offer_sdp, GLib.HashTable<string,GLib.Variant> peer_options, GLib.Cancellable? cancellable, out string answer_sdp) throws GLib.Error;
		public abstract async void post_messages (Frida.AgentMessage[] messages, uint batch_id, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void resume (uint rx_batch_id, GLib.Cancellable? cancellable, out uint tx_batch_id) throws GLib.Error;
		public abstract async uint8[] snapshot_script (string embed_script, GLib.HashTable<string,GLib.Variant> options, GLib.Cancellable? cancellable) throws GLib.Error;
		public signal void candidate_gathering_done ();
		public signal void new_candidates (string[] candidate_sdps);
	}
	[CCode (cheader_filename = "frida-base.h")]
	[DBus (name = "re.frida.AgentSessionProvider17")]
	public interface AgentSessionProvider : GLib.Object {
		public abstract async void migrate (Frida.AgentSessionId id, GLib.Socket to_socket, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void open (Frida.AgentSessionId id, GLib.HashTable<string,GLib.Variant> options, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void unload (GLib.Cancellable? cancellable) throws GLib.Error;
		public signal void child_gating_changed (uint subscriber_count);
		public signal void closed (Frida.AgentSessionId id);
		public signal void eternalized ();
		public signal void opened (Frida.AgentSessionId id);
	}
	[CCode (cheader_filename = "frida-base.h")]
	[DBus (name = "re.frida.AuthenticationService17")]
	public interface AuthenticationService : GLib.Object {
		public abstract async string authenticate (string token, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "frida-base.h")]
	[DBus (name = "re.frida.BusSession17")]
	public interface BusSession : GLib.Object {
		public abstract async void attach (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void post (string json, bool has_data, uint8[] data, GLib.Cancellable? cancellable) throws GLib.Error;
		public signal void message (string json, bool has_data, uint8[] data);
	}
	[CCode (cheader_filename = "frida-base.h")]
	[DBus (name = "re.frida.Channel17")]
	public interface Channel : GLib.Object {
		public abstract async void close (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void input (uint8[] data, GLib.Cancellable? cancellable) throws GLib.Error;
		public signal void output (uint8[] data);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public interface DynamicInterfaceObserver : GLib.Object {
		public abstract void start ();
		public signal void interface_attached (Frida.DynamicInterface iface);
		public signal void interface_detached (Frida.DynamicInterface iface);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public interface Future<T> : GLib.Object {
		public abstract T get_result () throws Frida.Error, GLib.IOError;
		public abstract void then (owned Frida.FutureCompletionHandler<T> handler);
		public abstract async T wait_async (GLib.Cancellable? cancellable) throws Frida.Error, GLib.IOError;
		public abstract GLib.Error? error { get; }
		public abstract bool ready { get; }
		public abstract T? value { get; }
	}
	[CCode (cheader_filename = "frida-base.h")]
	[DBus (name = "re.frida.HostSession17")]
	public interface HostSession : GLib.Object {
		public abstract async Frida.AgentSessionId attach (uint pid, GLib.HashTable<string,GLib.Variant> options, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void disable_spawn_gating (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void enable_spawn_gating (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Frida.HostApplicationInfo[] enumerate_applications (GLib.HashTable<string,GLib.Variant> options, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Frida.HostChildInfo[] enumerate_pending_children (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Frida.HostSpawnInfo[] enumerate_pending_spawn (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Frida.HostProcessInfo[] enumerate_processes (GLib.HashTable<string,GLib.Variant> options, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Frida.HostApplicationInfo get_frontmost_application (GLib.HashTable<string,GLib.Variant> options, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Frida.InjectorPayloadId inject_library_blob (uint pid, uint8[] blob, string entrypoint, string data, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Frida.InjectorPayloadId inject_library_file (uint pid, string path, string entrypoint, string data, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void input (uint pid, uint8[] data, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void kill (uint pid, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Frida.ChannelId open_channel (string address, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Frida.ServiceSessionId open_service (string address, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void ping (uint interval_seconds, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async GLib.HashTable<string,GLib.Variant> query_system_parameters (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void reattach (Frida.AgentSessionId id, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void resume (uint pid, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async uint spawn (string program, Frida.HostSpawnOptions options, GLib.Cancellable? cancellable) throws GLib.Error;
		public signal void agent_session_detached (Frida.AgentSessionId id, Frida.SessionDetachReason reason, Frida.CrashInfo crash);
		public signal void channel_closed (Frida.ChannelId id);
		public signal void child_added (Frida.HostChildInfo info);
		public signal void child_removed (Frida.HostChildInfo info);
		public signal void output (uint pid, int fd, uint8[] data);
		public signal void process_crashed (Frida.CrashInfo crash);
		public signal void service_session_closed (Frida.ServiceSessionId id);
		public signal void spawn_added (Frida.HostSpawnInfo info);
		public signal void spawn_removed (Frida.HostSpawnInfo info);
		public signal void uninjected (Frida.InjectorPayloadId id);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public interface ObjectBuilder : GLib.Object {
		public abstract unowned Frida.ObjectBuilder add_bool_value (bool val);
		public abstract unowned Frida.ObjectBuilder add_data_value (GLib.Bytes val);
		public abstract unowned Frida.ObjectBuilder add_int64_value (int64 val);
		public abstract unowned Frida.ObjectBuilder add_null_value ();
		public abstract unowned Frida.ObjectBuilder add_raw_value (GLib.Bytes val);
		public abstract unowned Frida.ObjectBuilder add_string_value (string val);
		public abstract unowned Frida.ObjectBuilder add_uint64_value (uint64 val);
		public abstract unowned Frida.ObjectBuilder add_uuid_value (uint8[] val);
		public abstract unowned Frida.ObjectBuilder begin_array ();
		public abstract unowned Frida.ObjectBuilder begin_dictionary ();
		public abstract GLib.Bytes build ();
		public abstract unowned Frida.ObjectBuilder end_array ();
		public abstract unowned Frida.ObjectBuilder end_dictionary ();
		public abstract unowned Frida.ObjectBuilder set_member_name (string name);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public interface ObjectReader : GLib.Object {
		public abstract uint count_elements () throws Frida.Error;
		public abstract unowned Frida.ObjectReader end_element () throws Frida.Error;
		public abstract unowned Frida.ObjectReader end_member ();
		public abstract bool get_bool_value () throws Frida.Error;
		public abstract GLib.Bytes get_data_value () throws Frida.Error;
		public abstract int64 get_int64_value () throws Frida.Error;
		public abstract unowned string get_string_value () throws Frida.Error;
		public abstract uint16 get_uint16_value () throws Frida.Error;
		public abstract uint64 get_uint64_value () throws Frida.Error;
		public abstract uint8 get_uint8_value () throws Frida.Error;
		public abstract unowned string get_uuid_value () throws Frida.Error;
		public abstract bool has_member (string name) throws Frida.Error;
		public abstract unowned Frida.ObjectReader read_element (uint index) throws Frida.Error;
		public abstract unowned Frida.ObjectReader read_member (string name) throws Frida.Error;
	}
	[CCode (cheader_filename = "frida-base.h")]
	[DBus (name = "re.frida.PortalSession17")]
	public interface PortalSession : GLib.Object {
		public abstract async void join (Frida.HostApplicationInfo app, Frida.SpawnStartState current_state, Frida.AgentSessionId[] interrupted_sessions, GLib.HashTable<string,GLib.Variant> options, GLib.Cancellable? cancellable, out Frida.SpawnStartState next_state) throws GLib.Error;
		public signal void kill ();
		public signal void resume ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public interface RpcPeer : GLib.Object {
		public abstract async void post_rpc_message (string json, GLib.Bytes? data, GLib.Cancellable? cancellable) throws Frida.Error, GLib.IOError;
	}
	[CCode (cheader_filename = "frida-base.h")]
	[DBus (name = "re.frida.ServiceSession17")]
	public interface ServiceSession : GLib.Object {
		public abstract async void activate (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async void cancel (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async GLib.Variant request (GLib.Variant parameters, GLib.Cancellable? cancellable) throws GLib.Error;
		public signal void close ();
		public signal void message (GLib.Variant message);
	}
	[CCode (cheader_filename = "frida-base.h")]
	[DBus (name = "re.frida.TransportBroker17")]
	public interface TransportBroker : GLib.Object {
		public abstract async void open_tcp_transport (Frida.AgentSessionId id, GLib.Cancellable? cancellable, out uint16 port, out string token) throws GLib.Error;
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct AgentMessage {
		public Frida.AgentMessageKind kind;
		public Frida.AgentScriptId script_id;
		public string text;
		public bool has_data;
		public uint8[] data;
		public AgentMessage (Frida.AgentMessageKind kind, Frida.AgentScriptId script_id, string text, bool has_data, uint8[] data);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct AgentScriptId {
		public uint handle;
		public AgentScriptId (uint handle);
		public static bool equal (Frida.AgentScriptId? a, Frida.AgentScriptId? b);
		public static uint hash (Frida.AgentScriptId? id);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct AgentSessionId {
		public string handle;
		public AgentSessionId (string handle);
		public static bool equal (Frida.AgentSessionId? a, Frida.AgentSessionId? b);
		public AgentSessionId.generate ();
		public static uint hash (Frida.AgentSessionId? id);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct ChannelId {
		public string handle;
		public ChannelId (string handle);
		public static bool equal (Frida.ChannelId? a, Frida.ChannelId? b);
		public ChannelId.generate ();
		public static uint hash (Frida.ChannelId? id);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct CrashInfo {
		public uint pid;
		public string process_name;
		public string summary;
		public string report;
		public GLib.HashTable<string,GLib.Variant> parameters;
		public CrashInfo (uint pid, string process_name, string summary, string report, GLib.HashTable<string,GLib.Variant>? parameters = null);
		public CrashInfo.empty ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct HostApplicationInfo {
		public string identifier;
		public string name;
		public uint pid;
		public GLib.HashTable<string,GLib.Variant> parameters;
		public HostApplicationInfo (string identifier, string name, uint pid, owned GLib.HashTable<string,GLib.Variant> parameters);
		public HostApplicationInfo.empty ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct HostChildId {
		public uint handle;
		public HostChildId (uint handle);
		public static bool equal (Frida.HostChildId? a, Frida.HostChildId? b);
		public static uint hash (Frida.HostChildId? id);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct HostChildInfo {
		public uint pid;
		public uint parent_pid;
		public Frida.ChildOrigin origin;
		public string identifier;
		public string path;
		public bool has_argv;
		public string[] argv;
		public bool has_envp;
		public string[] envp;
		public HostChildInfo (uint pid, uint parent_pid, Frida.ChildOrigin origin);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct HostProcessInfo {
		public uint pid;
		public string name;
		public GLib.HashTable<string,GLib.Variant> parameters;
		public HostProcessInfo (uint pid, string name, owned GLib.HashTable<string,GLib.Variant> parameters);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct HostSpawnInfo {
		public uint pid;
		public string identifier;
		public HostSpawnInfo (uint pid, string identifier);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct HostSpawnOptions {
		public bool has_argv;
		public string[] argv;
		public bool has_envp;
		public string[] envp;
		public bool has_env;
		public string[] env;
		public string cwd;
		public Frida.Stdio stdio;
		public GLib.HashTable<string,GLib.Variant> aux;
		public HostSpawnOptions ();
		public string[] compute_argv (string path);
		public string[] compute_envp ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct InjectorPayloadId {
		public uint handle;
		public InjectorPayloadId (uint handle);
		public static bool equal (Frida.InjectorPayloadId? a, Frida.InjectorPayloadId? b);
		public static uint hash (Frida.InjectorPayloadId? id);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct LinuxInjectorState {
		public int frida_ctrlfd;
		public int agent_ctrlfd;
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct MappedLibraryBlob {
		public uint64 address;
		public uint size;
		public uint allocated_size;
		public MappedLibraryBlob (uint64 address, uint size, uint allocated_size);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct PortalMembershipId {
		public uint handle;
		public PortalMembershipId (uint handle);
		public static bool equal (Frida.PortalMembershipId? a, Frida.PortalMembershipId? b);
		public static uint hash (Frida.PortalMembershipId? id);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct PosixInjectorState {
		public int fifo_fd;
	}
	[CCode (cheader_filename = "frida-base.h")]
	public struct ServiceSessionId {
		public string handle;
		public ServiceSessionId (string handle);
		public static bool equal (Frida.ServiceSessionId? a, Frida.ServiceSessionId? b);
		public ServiceSessionId.generate ();
		public static uint hash (Frida.ServiceSessionId? id);
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum AgentMessageKind {
		SCRIPT,
		DEBUGGER
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum ChildOrigin {
		FORK,
		EXEC,
		SPAWN;
		public static Frida.ChildOrigin from_nick (string nick) throws Frida.Error;
		public string to_nick ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	protected enum DcepMessageType {
		DATA_CHANNEL_OPEN,
		DATA_CHANNEL_ACK
	}
	[CCode (cheader_filename = "frida-base.h")]
	protected enum PayloadProtocolId {
		NONE,
		WEBRTC_DCEP,
		WEBRTC_STRING,
		WEBRTC_BINARY_PARTIAL,
		WEBRTC_BINARY,
		WEBRTC_STRING_PARTIAL,
		WEBRTC_STRING_EMPTY,
		WEBRTC_BINARY_EMPTY
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum PeerSetup {
		ACTIVE,
		PASSIVE,
		ACTPASS,
		HOLDCONN;
		public static Frida.PeerSetup from_nick (string nick) throws Frida.Error;
		public string to_nick ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum PortConflictBehavior {
		FAIL,
		PICK_NEXT
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum Realm {
		NATIVE,
		EMULATED;
		public static Frida.Realm from_nick (string nick) throws Frida.Error;
		public string to_nick ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum RelayKind {
		TURN_UDP,
		TURN_TCP,
		TURN_TLS
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum Scope {
		MINIMAL,
		METADATA,
		FULL;
		public static Frida.Scope from_nick (string nick) throws Frida.Error;
		public string to_nick ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum ScriptRuntime {
		DEFAULT,
		QJS,
		V8;
		public static Frida.ScriptRuntime from_nick (string nick) throws Frida.Error;
		public string to_nick ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	[Flags]
	protected enum SctpMessageFlags {
		END_OF_RECORD,
		NOTIFICATION
	}
	[CCode (cheader_filename = "frida-base.h")]
	protected enum SctpShutdownType {
		READ,
		WRITE,
		READ_WRITE
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum SessionDetachReason {
		APPLICATION_REQUESTED,
		PROCESS_REPLACED,
		PROCESS_TERMINATED,
		CONNECTION_TERMINATED,
		DEVICE_LOST;
		public static Frida.SessionDetachReason from_nick (string nick) throws Frida.Error;
		public string to_nick ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum SnapshotTransport {
		INLINE,
		SHARED_MEMORY
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum SpawnStartState {
		RUNNING,
		SUSPENDED;
		public static Frida.SpawnStartState from_nick (string nick) throws Frida.Error;
		public string to_nick ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum Stdio {
		INHERIT,
		PIPE;
		public static Frida.Stdio from_nick (string nick) throws Frida.Error;
		public string to_nick ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum StringTerminator {
		NONE,
		NUL
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum UnloadPolicy {
		IMMEDIATE,
		RESIDENT,
		DEFERRED;
		public static Frida.UnloadPolicy from_nick (string nick) throws Frida.Error;
		public string to_nick ();
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum WebServiceFlavor {
		CONTROL,
		CLUSTER
	}
	[CCode (cheader_filename = "frida-base.h")]
	public enum WebServiceTransport {
		PLAIN,
		TLS
	}
	[CCode (cheader_filename = "frida-base.h")]
	[DBus (name = "re.frida.Error")]
	public errordomain Error {
		SERVER_NOT_RUNNING,
		EXECUTABLE_NOT_FOUND,
		EXECUTABLE_NOT_SUPPORTED,
		PROCESS_NOT_FOUND,
		PROCESS_NOT_RESPONDING,
		INVALID_ARGUMENT,
		INVALID_OPERATION,
		PERMISSION_DENIED,
		ADDRESS_IN_USE,
		TIMED_OUT,
		NOT_SUPPORTED,
		PROTOCOL,
		TRANSPORT
	}
	[CCode (cheader_filename = "frida-base.h")]
	public delegate void FutureCompletionHandler<T> (Frida.Future<T> future);
	[CCode (cheader_filename = "frida-base.h")]
	public const uint16 DEFAULT_CLUSTER_PORT;
	[CCode (cheader_filename = "frida-base.h")]
	public const uint16 DEFAULT_CONTROL_PORT;
	[CCode (cheader_filename = "frida-base.h")]
	public static void _generate_certificate (out uint8[] cert_der, out string cert_pem, out string key_pem);
	[CCode (cheader_filename = "frida-base.h")]
	public static string _query_android_system_property (string name);
	[CCode (cheader_filename = "frida-base.h")]
	public static unowned string _version_string ();
	[CCode (cheader_filename = "frida-base.h")]
	public static bool check_kernel_version (uint major, uint minor);
	[CCode (cheader_filename = "frida-base.h")]
	public static GLib.HashTable<string,GLib.Variant> compute_system_parameters ();
	[CCode (cheader_filename = "frida-base.h")]
	public static async void generate_certificate (out uint8[] cert_der, out string cert_pem, out string key_pem);
	[CCode (cheader_filename = "frida-base.h")]
	public static async GLib.MainContext get_dbus_context ();
	[CCode (cheader_filename = "frida-base.h")]
	public static void invalidate_dbus_context ();
	[CCode (cheader_filename = "frida-base.h")]
	public static GLib.Bytes make_bytes_with_owner<T> (void* data, size_t size, owned T? owner = null);
	[CCode (cheader_filename = "frida-base.h")]
	public static GLib.HashTable<string,GLib.Variant> make_parameters_dict ();
	[CCode (cheader_filename = "frida-base.h")]
	public static async GLib.IOStream negotiate_connection (GLib.IOStream stream, Frida.WebServiceTransport transport, string host, string? origin, GLib.Cancellable? cancellable) throws Frida.Error, GLib.IOError;
	[CCode (cheader_filename = "frida-base.h")]
	public static GLib.SocketConnectable parse_cluster_address (string? address, uint16 port = 0) throws Frida.Error;
	[CCode (cheader_filename = "frida-base.h")]
	public static GLib.SocketConnectable parse_control_address (string? address, uint16 port = 0) throws Frida.Error;
	[CCode (cheader_filename = "frida-base.h")]
	public static GLib.SocketConnectable parse_socket_address (string? address, uint16 port, string default_address, uint16 default_port) throws Frida.Error;
	[CCode (cheader_filename = "frida-base.h")]
	[NoReturn]
	public static void throw_api_error (GLib.Error e) throws Frida.Error, GLib.IOError;
	[CCode (cheader_filename = "frida-base.h")]
	[NoReturn]
	public static void throw_dbus_error (GLib.Error e) throws Frida.Error, GLib.IOError;
}
