/*
 * Decompiled with CFR 0.152.
 */
package javax.media.protocol;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.media.Duration;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.URLSourceStream;

public class URLDataSource
extends PullDataSource {
    protected URLConnection conn;
    protected ContentDescriptor contentType;
    protected boolean connected;
    private URLSourceStream[] sources;

    protected URLDataSource() {
    }

    public URLDataSource(URL url) throws IOException {
        this.setLocator(new MediaLocator(url));
        this.connected = false;
    }

    @Override
    public PullSourceStream[] getStreams() {
        if (!this.connected) {
            throw new Error("Unconnected source.");
        }
        return this.sources;
    }

    @Override
    public void connect() throws IOException {
        this.conn = this.getLocator().getURL().openConnection();
        this.conn.connect();
        this.connected = true;
        String str = this.conn.getContentType();
        if (str == null) {
            str = "UnknownContent";
        }
        this.contentType = new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName(str));
        this.sources = new URLSourceStream[1];
        this.sources[0] = new URLSourceStream(this.conn, this.contentType);
    }

    @Override
    public String getContentType() {
        if (!this.connected) {
            throw new Error("Source is unconnected.");
        }
        return this.contentType.getContentType();
    }

    @Override
    public void disconnect() {
        if (this.connected) {
            try {
                this.sources[0].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connected = false;
        }
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void stop() throws IOException {
    }

    @Override
    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }

    @Override
    public Object[] getControls() {
        return new Object[0];
    }

    @Override
    public Object getControl(String controlName) {
        return null;
    }
}

