/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui.event;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import org.bluray.ui.event.HRcEvent;
import org.havi.ui.event.HEventRepresentation;
import org.havi.ui.event.HKeyCapabilities;

public class HRcCapabilities
extends HKeyCapabilities {
    private static final int[] supportedRcCode;

    protected HRcCapabilities() {
    }

    public static HEventRepresentation getRepresentation(int keyCode) {
        if (!HRcCapabilities.isSupported(keyCode)) {
            return null;
        }
        return new HEventRepresentation(HRcCapabilities.getKeyText(keyCode), HRcCapabilities.getKeyColor(keyCode), null);
    }

    public static boolean getInputDeviceSupported() {
        return true;
    }

    public static boolean isSupported(int keycode) {
        return Arrays.binarySearch(supportedRcCode, keycode) >= 0;
    }

    private static Color getKeyColor(int keyCode) {
        switch (keyCode) {
            case 403: {
                return Color.red;
            }
            case 404: {
                return Color.green;
            }
            case 405: {
                return Color.yellow;
            }
            case 406: {
                return Color.blue;
            }
        }
        return null;
    }

    private static String getKeyText(int keyCode) {
        if (keyCode >= 400 && keyCode <= 465) {
            switch (keyCode) {
                case 452: {
                    return "Balance Left";
                }
                case 451: {
                    return "Balance Right";
                }
                case 456: {
                    return "Bass Boost Down";
                }
                case 455: {
                    return "Bass Boost Up";
                }
                case 428: {
                    return "Channel Down";
                }
                case 427: {
                    return "Channel Up";
                }
                case 437: {
                    return "Clear Favorite 1";
                }
                case 438: {
                    return "Clear Favorite 1";
                }
                case 439: {
                    return "Clear Favorite 1";
                }
                case 440: {
                    return "Clear Favorite 1";
                }
                case 403: {
                    return "Colored Key 0";
                }
                case 404: {
                    return "Colored Key 1";
                }
                case 405: {
                    return "Colored Key 2";
                }
                case 406: {
                    return "Colored Key 3";
                }
                case 407: {
                    return "Colored Key 4";
                }
                case 408: {
                    return "Colored Key 5";
                }
                case 410: {
                    return "Dimmer";
                }
                case 444: {
                    return "Swap Display";
                }
                case 414: {
                    return "Toggle Eject";
                }
                case 453: {
                    return "Fader Front";
                }
                case 454: {
                    return "Fader Rear";
                }
                case 417: {
                    return "Fast Farward";
                }
                case 423: {
                    return "GGo to End";
                }
                case 422: {
                    return "Go to Start";
                }
                case 458: {
                    return "Guide";
                }
                case 457: {
                    return "Infomation";
                }
                case 449: {
                    return "Mute";
                }
                case 442: {
                    return "Toggle Picture-in-picture";
                }
                case 415: {
                    return "Play";
                }
                case 419: {
                    return "Play Speed Down";
                }
                case 420: {
                    return "Play Speed Reset";
                }
                case 418: {
                    return "Play Speed Up";
                }
                case 409: {
                    return "Power";
                }
                case 426: {
                    return "Toggle Random";
                }
                case 433: {
                    return "Recall Favorite 0";
                }
                case 434: {
                    return "Recall Favorite 1";
                }
                case 435: {
                    return "Recall Favorite 2";
                }
                case 436: {
                    return "Recall Favorite 3";
                }
                case 416: {
                    return "Record";
                }
                case 421: {
                    return "Next Record Speed";
                }
                case 412: {
                    return "Rewind";
                }
                case 441: {
                    return "Toggle Scan Channels";
                }
                case 445: {
                    return "Next Screen Mode";
                }
                case 443: {
                    return "Toggle Split Screen";
                }
                case 413: {
                    return "Stop";
                }
                case 429: {
                    return "Store Favorite 0";
                }
                case 430: {
                    return "Store Favorite 1";
                }
                case 431: {
                    return "Store Favorite 2";
                }
                case 432: {
                    return "Store Favorite 3";
                }
                case 460: {
                    return "Subtitle";
                }
                case 450: {
                    return "Next Surround Mode";
                }
                case 459: {
                    return "Teletext";
                }
                case 425: {
                    return "Next Track";
                }
                case 424: {
                    return "Preview Track";
                }
                case 446: {
                    return "Next Video Mode";
                }
                case 448: {
                    return "Volume Down";
                }
                case 447: {
                    return "Volume Up";
                }
                case 411: {
                    return "Win Key";
                }
            }
        }
        return KeyEvent.getKeyText(keyCode);
    }

    static {
        int i;
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(10);
        list.add(37);
        list.add(38);
        list.add(39);
        list.add(40);
        for (int i2 = 0; i2 < 9; ++i2) {
            list.add(48 + i2);
        }
        Field[] fields = HRcEvent.class.getFields();
        for (i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            if (!name.startsWith("VK_") || name.equals("VK_UNDEFINED")) continue;
            try {
                int keyCode = fields[i].getInt(null);
                if (keyCode <= 400 || keyCode > 465) continue;
                list.add(keyCode);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        supportedRcCode = new int[list.size()];
        for (i = 0; i < list.size(); ++i) {
            HRcCapabilities.supportedRcCode[i] = (Integer)list.get(i);
        }
        Arrays.sort(supportedRcCode);
    }
}

